<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get Tracking
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTuDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\TuDetailsRequestType $getTuDetailRequest
     * @return \GlsApi\TuDetailsResponseType|bool
     */
    public function GetTuDetail(\GlsApi\TuDetailsRequestType $getTuDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuDetail($getTuDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTuList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\TuListRequestType $getTuListRequest
     * @return \GlsApi\TuListResponseType|bool
     */
    public function GetTuList(\GlsApi\TuListRequestType $getTuListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuList($getTuListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTuPOD
     * Meta information extracted from the WSDL
     * - documentation: Method to extract the signature of a POD. The result will contain original filename <PODFileName /> and a <PODFile /> that is the binary file encoded in BASE64
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\TuPODRequestType $getTuPODRequest
     * @return \GlsApi\TuPODResponseType|bool
     */
    public function GetTuPOD(\GlsApi\TuPODRequestType $getTuPODRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTuPOD($getTuPODRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTusDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\TusDetailsRequestType $getTusDetailsRequest
     * @return \GlsApi\TusDetailsReponseType|bool
     */
    public function GetTusDetails(\GlsApi\TusDetailsRequestType $getTusDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTusDetails($getTusDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsApi\TuDetailsResponseType|\GlsApi\TuListResponseType|\GlsApi\TuPODResponseType|\GlsApi\TusDetailsReponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
