<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TusDetailsReponseType Tracking
 * @subpackage Structs
 */
class TusDetailsReponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TusDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GlsApi\TuDetailsResponseType[]
     */
    public $TusDetails;
    /**
     * Constructor method for TusDetailsReponseType
     * @uses TusDetailsReponseType::setExitCode()
     * @uses TusDetailsReponseType::setTusDetails()
     * @param \GlsApi\GLSExitCode $exitCode
     * @param \GlsApi\TuDetailsResponseType[] $tusDetails
     */
    public function __construct(\GlsApi\GLSExitCode $exitCode = null, array $tusDetails = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setTusDetails($tusDetails);
    }
    /**
     * Get ExitCode value
     * @return \GlsApi\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \GlsApi\GLSExitCode $exitCode
     * @return \GlsApi\TusDetailsReponseType
     */
    public function setExitCode(\GlsApi\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TusDetails value
     * @return \GlsApi\TuDetailsResponseType[]|null
     */
    public function getTusDetails()
    {
        return $this->TusDetails;
    }
    /**
     * Set TusDetails value
     * @param \GlsApi\TuDetailsResponseType[] $tusDetails
     * @return \GlsApi\TusDetailsReponseType
     */
    public function setTusDetails(array $tusDetails = array())
    {
        $this->TusDetails = $tusDetails;
        return $this;
    }
    /**
     * Add item to TusDetails value
     * @throws \InvalidArgumentException
     * @param \GlsApi\TuDetailsResponseType $item
     * @return \GlsApi\TusDetailsReponseType
     */
    public function addToTusDetails(\GlsApi\TuDetailsResponseType $item)
    {
        $this->TusDetails[] = $item;
        return $this;
    }
}
