<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuPODRequestType Tracking
 * @subpackage Structs
 */
class TuPODRequestType extends AbstractStructBase
{
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RefValue;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GlsApi\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuPODRequestType
     * @uses TuPODRequestType::setCredentials()
     * @uses TuPODRequestType::setRefValue()
     * @uses TuPODRequestType::setParameters()
     * @param \GlsApi\GLSUserCredentials $credentials
     * @param string $refValue
     * @param \GlsApi\GLSParameters[] $parameters
     */
    public function __construct(\GlsApi\GLSUserCredentials $credentials = null, $refValue = null, array $parameters = array())
    {
        $this
            ->setCredentials($credentials)
            ->setRefValue($refValue)
            ->setParameters($parameters);
    }
    /**
     * Get Credentials value
     * @return \GlsApi\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GlsApi\GLSUserCredentials $credentials
     * @return \GlsApi\TuPODRequestType
     */
    public function setCredentials(\GlsApi\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get RefValue value
     * @return string
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \GlsApi\TuPODRequestType
     */
    public function setRefValue($refValue = null)
    {
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GlsApi\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \GlsApi\GLSParameters[] $parameters
     * @return \GlsApi\TuPODRequestType
     */
    public function setParameters(array $parameters = array())
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GlsApi\GLSParameters $item
     * @return \GlsApi\TuPODRequestType
     */
    public function addToParameters(\GlsApi\GLSParameters $item)
    {
        $this->Parameters[] = $item;
        return $this;
    }
}
