<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuDetailsResponseType Tracking
 * @subpackage Structs
 */
class TuDetailsResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TuNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TuNo;
    /**
     * The NationalRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NationalRef;
    /**
     * The ConsigneeAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSAddress
     */
    public $ConsigneeAddress;
    /**
     * The ShipperAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSAddress
     */
    public $ShipperAddress;
    /**
     * The RequesterAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSAddress
     */
    public $RequesterAddress;
    /**
     * The DeliveryDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSDateTime
     */
    public $DeliveryDateTime;
    /**
     * The PickupDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSDateTime
     */
    public $PickupDateTime;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Product;
    /**
     * The TuWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TuWeight;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var string[]
     */
    public $Services;
    /**
     * The CustomerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \GlsApi\GLSCustomerReference[]
     */
    public $CustomerReference;
    /**
     * The History
     * Meta information extracted from the WSDL
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \GlsApi\GLSEvent[]
     */
    public $History;
    /**
     * The Signature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Signature;
    /**
     * Constructor method for TuDetailsResponseType
     * @uses TuDetailsResponseType::setExitCode()
     * @uses TuDetailsResponseType::setTuNo()
     * @uses TuDetailsResponseType::setNationalRef()
     * @uses TuDetailsResponseType::setConsigneeAddress()
     * @uses TuDetailsResponseType::setShipperAddress()
     * @uses TuDetailsResponseType::setRequesterAddress()
     * @uses TuDetailsResponseType::setDeliveryDateTime()
     * @uses TuDetailsResponseType::setPickupDateTime()
     * @uses TuDetailsResponseType::setProduct()
     * @uses TuDetailsResponseType::setTuWeight()
     * @uses TuDetailsResponseType::setServices()
     * @uses TuDetailsResponseType::setCustomerReference()
     * @uses TuDetailsResponseType::setHistory()
     * @uses TuDetailsResponseType::setSignature()
     * @param \GlsApi\GLSExitCode $exitCode
     * @param string $tuNo
     * @param string $nationalRef
     * @param \GlsApi\GLSAddress $consigneeAddress
     * @param \GlsApi\GLSAddress $shipperAddress
     * @param \GlsApi\GLSAddress $requesterAddress
     * @param \GlsApi\GLSDateTime $deliveryDateTime
     * @param \GlsApi\GLSDateTime $pickupDateTime
     * @param string $product
     * @param float $tuWeight
     * @param string[] $services
     * @param \GlsApi\GLSCustomerReference[] $customerReference
     * @param \GlsApi\GLSEvent[] $history
     * @param string $signature
     */
    public function __construct(\GlsApi\GLSExitCode $exitCode = null, $tuNo = null, $nationalRef = null, \GlsApi\GLSAddress $consigneeAddress = null, \GlsApi\GLSAddress $shipperAddress = null, \GlsApi\GLSAddress $requesterAddress = null, \GlsApi\GLSDateTime $deliveryDateTime = null, \GlsApi\GLSDateTime $pickupDateTime = null, $product = null, $tuWeight = null, array $services = array(), array $customerReference = array(), array $history = array(), $signature = null)
    {
        $this
            ->setExitCode($exitCode)
            ->setTuNo($tuNo)
            ->setNationalRef($nationalRef)
            ->setConsigneeAddress($consigneeAddress)
            ->setShipperAddress($shipperAddress)
            ->setRequesterAddress($requesterAddress)
            ->setDeliveryDateTime($deliveryDateTime)
            ->setPickupDateTime($pickupDateTime)
            ->setProduct($product)
            ->setTuWeight($tuWeight)
            ->setServices($services)
            ->setCustomerReference($customerReference)
            ->setHistory($history)
            ->setSignature($signature);
    }
    /**
     * Get ExitCode value
     * @return \GlsApi\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \GlsApi\GLSExitCode $exitCode
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setExitCode(\GlsApi\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TuNo value
     * @return string
     */
    public function getTuNo()
    {
        return $this->TuNo;
    }
    /**
     * Set TuNo value
     * @param string $tuNo
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setTuNo($tuNo = null)
    {
        $this->TuNo = $tuNo;
        return $this;
    }
    /**
     * Get NationalRef value
     * @return string
     */
    public function getNationalRef()
    {
        return $this->NationalRef;
    }
    /**
     * Set NationalRef value
     * @param string $nationalRef
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setNationalRef($nationalRef = null)
    {
        $this->NationalRef = $nationalRef;
        return $this;
    }
    /**
     * Get ConsigneeAddress value
     * @return \GlsApi\GLSAddress
     */
    public function getConsigneeAddress()
    {
        return $this->ConsigneeAddress;
    }
    /**
     * Set ConsigneeAddress value
     * @param \GlsApi\GLSAddress $consigneeAddress
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setConsigneeAddress(\GlsApi\GLSAddress $consigneeAddress = null)
    {
        $this->ConsigneeAddress = $consigneeAddress;
        return $this;
    }
    /**
     * Get ShipperAddress value
     * @return \GlsApi\GLSAddress
     */
    public function getShipperAddress()
    {
        return $this->ShipperAddress;
    }
    /**
     * Set ShipperAddress value
     * @param \GlsApi\GLSAddress $shipperAddress
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setShipperAddress(\GlsApi\GLSAddress $shipperAddress = null)
    {
        $this->ShipperAddress = $shipperAddress;
        return $this;
    }
    /**
     * Get RequesterAddress value
     * @return \GlsApi\GLSAddress
     */
    public function getRequesterAddress()
    {
        return $this->RequesterAddress;
    }
    /**
     * Set RequesterAddress value
     * @param \GlsApi\GLSAddress $requesterAddress
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setRequesterAddress(\GlsApi\GLSAddress $requesterAddress = null)
    {
        $this->RequesterAddress = $requesterAddress;
        return $this;
    }
    /**
     * Get DeliveryDateTime value
     * @return \GlsApi\GLSDateTime
     */
    public function getDeliveryDateTime()
    {
        return $this->DeliveryDateTime;
    }
    /**
     * Set DeliveryDateTime value
     * @param \GlsApi\GLSDateTime $deliveryDateTime
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setDeliveryDateTime(\GlsApi\GLSDateTime $deliveryDateTime = null)
    {
        $this->DeliveryDateTime = $deliveryDateTime;
        return $this;
    }
    /**
     * Get PickupDateTime value
     * @return \GlsApi\GLSDateTime
     */
    public function getPickupDateTime()
    {
        return $this->PickupDateTime;
    }
    /**
     * Set PickupDateTime value
     * @param \GlsApi\GLSDateTime $pickupDateTime
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setPickupDateTime(\GlsApi\GLSDateTime $pickupDateTime = null)
    {
        $this->PickupDateTime = $pickupDateTime;
        return $this;
    }
    /**
     * Get Product value
     * @return string
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param string $product
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setProduct($product = null)
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Get TuWeight value
     * @return float
     */
    public function getTuWeight()
    {
        return $this->TuWeight;
    }
    /**
     * Set TuWeight value
     * @param float $tuWeight
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setTuWeight($tuWeight = null)
    {
        $this->TuWeight = $tuWeight;
        return $this;
    }
    /**
     * Get Services value
     * @return string[]|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param string[] $services
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setServices(array $services = array())
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Add item to Services value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GlsApi\TuDetailsResponseType
     */
    public function addToServices($item)
    {
        $this->Services[] = $item;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return \GlsApi\GLSCustomerReference[]|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param \GlsApi\GLSCustomerReference[] $customerReference
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setCustomerReference(array $customerReference = array())
    {
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Add item to CustomerReference value
     * @throws \InvalidArgumentException
     * @param \GlsApi\GLSCustomerReference $item
     * @return \GlsApi\TuDetailsResponseType
     */
    public function addToCustomerReference(\GlsApi\GLSCustomerReference $item)
    {
        $this->CustomerReference[] = $item;
        return $this;
    }
    /**
     * Get History value
     * @return \GlsApi\GLSEvent[]|null
     */
    public function getHistory()
    {
        return $this->History;
    }
    /**
     * Set History value
     * @param \GlsApi\GLSEvent[] $history
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setHistory(array $history = array())
    {
        $this->History = $history;
        return $this;
    }
    /**
     * Add item to History value
     * @throws \InvalidArgumentException
     * @param \GlsApi\GLSEvent $item
     * @return \GlsApi\TuDetailsResponseType
     */
    public function addToHistory(\GlsApi\GLSEvent $item)
    {
        $this->History[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @param string $signature
     * @return \GlsApi\TuDetailsResponseType
     */
    public function setSignature($signature = null)
    {
        $this->Signature = $signature;
        return $this;
    }
}
