<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuListResponseType Tracking
 * @subpackage Structs
 */
class TuListResponseType extends AbstractStructBase
{
    /**
     * The ExitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSExitCode
     */
    public $ExitCode;
    /**
     * The TUList
     * Meta information extracted from the WSDL
     * - maxOccurs: 10000
     * - minOccurs: 0
     * @var \GlsApi\GLSUnitRow[]
     */
    public $TUList;
    /**
     * Constructor method for TuListResponseType
     * @uses TuListResponseType::setExitCode()
     * @uses TuListResponseType::setTUList()
     * @param \GlsApi\GLSExitCode $exitCode
     * @param \GlsApi\GLSUnitRow[] $tUList
     */
    public function __construct(\GlsApi\GLSExitCode $exitCode = null, array $tUList = array())
    {
        $this
            ->setExitCode($exitCode)
            ->setTUList($tUList);
    }
    /**
     * Get ExitCode value
     * @return \GlsApi\GLSExitCode
     */
    public function getExitCode()
    {
        return $this->ExitCode;
    }
    /**
     * Set ExitCode value
     * @param \GlsApi\GLSExitCode $exitCode
     * @return \GlsApi\TuListResponseType
     */
    public function setExitCode(\GlsApi\GLSExitCode $exitCode = null)
    {
        $this->ExitCode = $exitCode;
        return $this;
    }
    /**
     * Get TUList value
     * @return \GlsApi\GLSUnitRow[]|null
     */
    public function getTUList()
    {
        return $this->TUList;
    }
    /**
     * Set TUList value
     * @param \GlsApi\GLSUnitRow[] $tUList
     * @return \GlsApi\TuListResponseType
     */
    public function setTUList(array $tUList = array())
    {
        $this->TUList = $tUList;
        return $this;
    }
    /**
     * Add item to TUList value
     * @throws \InvalidArgumentException
     * @param \GlsApi\GLSUnitRow $item
     * @return \GlsApi\TuListResponseType
     */
    public function addToTUList(\GlsApi\GLSUnitRow $item)
    {
        $this->TUList[] = $item;
        return $this;
    }
}
