<?php

namespace GlsApi;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TuListRequestType Tracking
 * @subpackage Structs
 */
class TuListRequestType extends AbstractStructBase
{
    /**
     * The Credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GlsApi\GLSUserCredentials
     */
    public $Credentials;
    /**
     * The RefValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefValue;
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsApi\GLSDateTime
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GlsApi\GLSDateTime
     */
    public $DateTo;
    /**
     * The CustomRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomRef;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GlsApi\GLSParameters[]
     */
    public $Parameters;
    /**
     * Constructor method for TuListRequestType
     * @uses TuListRequestType::setCredentials()
     * @uses TuListRequestType::setRefValue()
     * @uses TuListRequestType::setDateFrom()
     * @uses TuListRequestType::setDateTo()
     * @uses TuListRequestType::setCustomRef()
     * @uses TuListRequestType::setParameters()
     * @param \GlsApi\GLSUserCredentials $credentials
     * @param string $refValue
     * @param \GlsApi\GLSDateTime $dateFrom
     * @param \GlsApi\GLSDateTime $dateTo
     * @param string $customRef
     * @param \GlsApi\GLSParameters[] $parameters
     */
    public function __construct(\GlsApi\GLSUserCredentials $credentials = null, $refValue = null, \GlsApi\GLSDateTime $dateFrom = null, \GlsApi\GLSDateTime $dateTo = null, $customRef = null, array $parameters = array())
    {
        $this
            ->setCredentials($credentials)
            ->setRefValue($refValue)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setCustomRef($customRef)
            ->setParameters($parameters);
    }
    /**
     * Get Credentials value
     * @return \GlsApi\GLSUserCredentials
     */
    public function getCredentials()
    {
        return $this->Credentials;
    }
    /**
     * Set Credentials value
     * @param \GlsApi\GLSUserCredentials $credentials
     * @return \GlsApi\TuListRequestType
     */
    public function setCredentials(\GlsApi\GLSUserCredentials $credentials = null)
    {
        $this->Credentials = $credentials;
        return $this;
    }
    /**
     * Get RefValue value
     * @return string|null
     */
    public function getRefValue()
    {
        return $this->RefValue;
    }
    /**
     * Set RefValue value
     * @param string $refValue
     * @return \GlsApi\TuListRequestType
     */
    public function setRefValue($refValue = null)
    {
        $this->RefValue = $refValue;
        return $this;
    }
    /**
     * Get DateFrom value
     * @return \GlsApi\GLSDateTime|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param \GlsApi\GLSDateTime $dateFrom
     * @return \GlsApi\TuListRequestType
     */
    public function setDateFrom(\GlsApi\GLSDateTime $dateFrom = null)
    {
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return \GlsApi\GLSDateTime|null
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param \GlsApi\GLSDateTime $dateTo
     * @return \GlsApi\TuListRequestType
     */
    public function setDateTo(\GlsApi\GLSDateTime $dateTo = null)
    {
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get CustomRef value
     * @return string|null
     */
    public function getCustomRef()
    {
        return $this->CustomRef;
    }
    /**
     * Set CustomRef value
     * @param string $customRef
     * @return \GlsApi\TuListRequestType
     */
    public function setCustomRef($customRef = null)
    {
        $this->CustomRef = $customRef;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \GlsApi\GLSParameters[]|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \GlsApi\GLSParameters[] $parameters
     * @return \GlsApi\TuListRequestType
     */
    public function setParameters(array $parameters = array())
    {
        $this->Parameters = $parameters;
        return $this;
    }
    /**
     * Add item to Parameters value
     * @throws \InvalidArgumentException
     * @param \GlsApi\GLSParameters $item
     * @return \GlsApi\TuListRequestType
     */
    public function addToParameters(\GlsApi\GLSParameters $item)
    {
        $this->Parameters[] = $item;
        return $this;
    }
}
