<?php

namespace MondialRelay\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for WSID ServiceType
 * @subpackage Services
 */
class WSID extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WSI2_DetailPointRelais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MondialRelay\StructType\WSI2_DetailPointRelais $parameters
     * @return \MondialRelay\StructType\WSI2_DetailPointRelaisResponse|bool
     */
    public function WSI2_DetailPointRelais(\MondialRelay\StructType\WSI2_DetailPointRelais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WSI2_DetailPointRelais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MondialRelay\StructType\WSI2_DetailPointRelaisResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
