<?php

namespace Colissimo\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @subpackage Services
 */
class Generate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named generateBordereauByParcelsNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Colissimo\StructType\GenerateBordereauByParcelsNumbers $parameters
     * @return \Colissimo\StructType\GenerateBordereauByParcelsNumbersResponse|bool
     */
    public function generateBordereauByParcelsNumbers(\Colissimo\StructType\GenerateBordereauByParcelsNumbers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateBordereauByParcelsNumbers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateTokenService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Colissimo\StructType\GenerateTokenService $parameters
     * @return \Colissimo\StructType\GenerateTokenServiceResponse|bool
     */
    public function generateTokenService(\Colissimo\StructType\GenerateTokenService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateTokenService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateCN23
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Colissimo\StructType\GenerateCN23 $parameters
     * @return \Colissimo\StructType\GenerateCN23Response|bool
     */
    public function generateCN23(\Colissimo\StructType\GenerateCN23 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateCN23($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateLabelService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Colissimo\StructType\GenerateLabelService $parameters
     * @return \Colissimo\StructType\GenerateLabelServiceResponse|bool
     */
    public function generateLabelService(\Colissimo\StructType\GenerateLabelService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateLabelService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateCN23Service
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Colissimo\StructType\GenerateCN23Service $parameters
     * @return \Colissimo\StructType\GenerateCN23ServiceResponse|bool
     */
    public function generateCN23Service(\Colissimo\StructType\GenerateCN23Service $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateCN23Service($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Colissimo\StructType\GenerateLabel $parameters
     * @return \Colissimo\StructType\GenerateLabelResponse|bool
     */
    public function generateLabel(\Colissimo\StructType\GenerateLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * generateBordereauByParcelsNumbersService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Colissimo\StructType\GenerateBordereauByParcelsNumbersService $parameters
     * @return \Colissimo\StructType\GenerateBordereauByParcelsNumbersServiceResponse|bool
     */
    public function generateBordereauByParcelsNumbersService(\Colissimo\StructType\GenerateBordereauByParcelsNumbersService $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateBordereauByParcelsNumbersService($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Colissimo\StructType\GenerateToken $parameters
     * @return \Colissimo\StructType\GenerateTokenResponse|bool
     */
    public function generateToken(\Colissimo\StructType\GenerateToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Colissimo\StructType\GenerateBordereauByParcelsNumbersResponse|\Colissimo\StructType\GenerateBordereauByParcelsNumbersServiceResponse|\Colissimo\StructType\GenerateCN23Response|\Colissimo\StructType\GenerateCN23ServiceResponse|\Colissimo\StructType\GenerateLabelResponse|\Colissimo\StructType\GenerateLabelServiceResponse|\Colissimo\StructType\GenerateTokenResponse|\Colissimo\StructType\GenerateTokenServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
