<?php

namespace sage\HRExportImport\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createJobOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \sage\HRExportImport\StructType\CreateJobOffer $parameters
     * @return \sage\HRExportImport\StructType\CreateJobOfferResponse|bool
     */
    public function createJobOffer(\sage\HRExportImport\StructType\CreateJobOffer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createJobOffer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createSageHRJobOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \sage\HRExportImport\StructType\CreateSageHRJobOffer $parameters
     * @return \sage\HRExportImport\StructType\CreateSageHRJobOfferResponse|bool
     */
    public function createSageHRJobOffer(\sage\HRExportImport\StructType\CreateSageHRJobOffer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createSageHRJobOffer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \sage\HRExportImport\StructType\CreateJobOfferResponse|\sage\HRExportImport\StructType\CreateSageHRJobOfferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
