<?php

namespace sage\HRExportImport\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importApplicant
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \sage\HRExportImport\StructType\ImportApplicant $parameters
     * @return \sage\HRExportImport\StructType\ImportApplicantResponse|bool
     */
    public function importApplicant(\sage\HRExportImport\StructType\ImportApplicant $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->importApplicant($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importOutlookMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \sage\HRExportImport\StructType\ImportOutlookMessage $parameters
     * @return \sage\HRExportImport\StructType\ImportOutlookMessageResponse|bool
     */
    public function importOutlookMessage(\sage\HRExportImport\StructType\ImportOutlookMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->importOutlookMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \sage\HRExportImport\StructType\ImportApplicantResponse|\sage\HRExportImport\StructType\ImportOutlookMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
