<?php

namespace sage\HRExportImport\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Export ServiceType
 * @subpackage Services
 */
class Export extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named exportJobOffers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \sage\HRExportImport\StructType\ExportJobOffers $parameters
     * @return \sage\HRExportImport\StructType\ExportJobOffersResponse|bool
     */
    public function exportJobOffers(\sage\HRExportImport\StructType\ExportJobOffers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->exportJobOffers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \sage\HRExportImport\StructType\ExportJobOffersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
