<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \sage\HRExportImport\ClassMap::get(),
);
/**
 * Samples for Import ServiceType
 */
$import = new \sage\HRExportImport\ServiceType\Import($options);
/**
 * Sample call for importApplicant operation/method
 */
if ($import->importApplicant(new \sage\HRExportImport\StructType\ImportApplicant()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for importOutlookMessage operation/method
 */
if ($import->importOutlookMessage(new \sage\HRExportImport\StructType\ImportOutlookMessage()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \sage\HRExportImport\ServiceType\Update($options);
/**
 * Sample call for updateSageHRJobOffer operation/method
 */
if ($update->updateSageHRJobOffer(new \sage\HRExportImport\StructType\UpdateSageHRJobOffer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateJobOffer operation/method
 */
if ($update->updateJobOffer(new \sage\HRExportImport\StructType\UpdateJobOffer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \sage\HRExportImport\ServiceType\Create($options);
/**
 * Sample call for createJobOffer operation/method
 */
if ($create->createJobOffer(new \sage\HRExportImport\StructType\CreateJobOffer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createSageHRJobOffer operation/method
 */
if ($create->createSageHRJobOffer(new \sage\HRExportImport\StructType\CreateSageHRJobOffer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Export ServiceType
 */
$export = new \sage\HRExportImport\ServiceType\Export($options);
/**
 * Sample call for exportJobOffers operation/method
 */
if ($export->exportJobOffers(new \sage\HRExportImport\StructType\ExportJobOffers()) !== false) {
    print_r($export->getResult());
} else {
    print_r($export->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \sage\HRExportImport\ServiceType\Set($options);
/**
 * Sample call for setOverwrite operation/method
 */
if ($set->setOverwrite(new \sage\HRExportImport\StructType\SetOverwrite()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \sage\HRExportImport\ServiceType\Get($options);
/**
 * Sample call for getReferenceData operation/method
 */
if ($get->getReferenceData(new \sage\HRExportImport\StructType\GetReferenceData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
