<?php

namespace sage\HRExportImport\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateSageHRJobOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \sage\HRExportImport\StructType\UpdateSageHRJobOffer $parameters
     * @return \sage\HRExportImport\StructType\UpdateSageHRJobOfferResponse|bool
     */
    public function updateSageHRJobOffer(\sage\HRExportImport\StructType\UpdateSageHRJobOffer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSageHRJobOffer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateJobOffer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \sage\HRExportImport\StructType\UpdateJobOffer $parameters
     * @return \sage\HRExportImport\StructType\UpdateJobOfferResponse|bool
     */
    public function updateJobOffer(\sage\HRExportImport\StructType\UpdateJobOffer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->updateJobOffer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \sage\HRExportImport\StructType\UpdateJobOfferResponse|\sage\HRExportImport\StructType\UpdateSageHRJobOfferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
