<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://services.aifasoft.com/ERPSYSNC/ERPSyncronization.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://services.aifasoft.com/ERPSYSNC/ERPSyncronization.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderLogin(new \StructType\Login());
/**
 * Sample call for GetErpMembers operation/method
 */
if ($get->GetErpMembers(new \StructType\GetErpMembers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFXProducts operation/method
 */
if ($get->GetFXProducts(new \StructType\GetFXProducts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFXOrders operation/method
 */
if ($get->GetFXOrders(new \StructType\GetFXOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFXMembers operation/method
 */
if ($get->GetFXMembers(new \StructType\GetFXMembers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFXERPBalances operation/method
 */
if ($get->GetFXERPBalances(new \StructType\GetFXERPBalances()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Sync ServiceType
 */
$sync = new \ServiceType\Sync($options);
$sync->setSoapHeaderLogin(new \StructType\Login());
/**
 * Sample call for SyncERPBalance operation/method
 */
if ($sync->SyncERPBalance(new \StructType\SyncERPBalance()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderLogin(new \StructType\Login());
/**
 * Sample call for CreateAccount operation/method
 */
if ($create->CreateAccount(new \StructType\CreateAccount()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Client ServiceType
 */
$client = new \ServiceType\Client($options);
$client->setSoapHeaderLogin(new \StructType\Login());
/**
 * Sample call for ClientLogin operation/method
 */
if ($client->ClientLogin(new \StructType\ClientLogin()) !== false) {
    print_r($client->getResult());
} else {
    print_r($client->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
$send->setSoapHeaderLogin(new \StructType\Login());
/**
 * Sample call for SendOrder operation/method
 */
if ($send->SendOrder(new \StructType\SendOrder()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
