<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login StructType
 * Meta information extracted from the WSDL
 * - type: tns:Login
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The ServerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServerId;
    /**
     * The ProviderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProviderName;
    /**
     * The DPEServer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DPEServer;
    /**
     * The PortNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PortNo;
    /**
     * The DBName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DBName;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The ERPServer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ERPServer;
    /**
     * The ERPDatabase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ERPDatabase;
    /**
     * The ERPUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ERPUserID;
    /**
     * The ERPPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ERPPassword;
    /**
     * Constructor method for Login
     * @uses Login::setServerId()
     * @uses Login::setProviderName()
     * @uses Login::setDPEServer()
     * @uses Login::setPortNo()
     * @uses Login::setDBName()
     * @uses Login::setUserName()
     * @uses Login::setPassword()
     * @uses Login::setERPServer()
     * @uses Login::setERPDatabase()
     * @uses Login::setERPUserID()
     * @uses Login::setERPPassword()
     * @param string $serverId
     * @param string $providerName
     * @param string $dPEServer
     * @param string $portNo
     * @param string $dBName
     * @param string $userName
     * @param string $password
     * @param string $eRPServer
     * @param string $eRPDatabase
     * @param string $eRPUserID
     * @param string $eRPPassword
     */
    public function __construct($serverId = null, $providerName = null, $dPEServer = null, $portNo = null, $dBName = null, $userName = null, $password = null, $eRPServer = null, $eRPDatabase = null, $eRPUserID = null, $eRPPassword = null)
    {
        $this
            ->setServerId($serverId)
            ->setProviderName($providerName)
            ->setDPEServer($dPEServer)
            ->setPortNo($portNo)
            ->setDBName($dBName)
            ->setUserName($userName)
            ->setPassword($password)
            ->setERPServer($eRPServer)
            ->setERPDatabase($eRPDatabase)
            ->setERPUserID($eRPUserID)
            ->setERPPassword($eRPPassword);
    }
    /**
     * Get ServerId value
     * @return string|null
     */
    public function getServerId()
    {
        return $this->ServerId;
    }
    /**
     * Set ServerId value
     * @param string $serverId
     * @return \StructType\Login
     */
    public function setServerId($serverId = null)
    {
        // validation for constraint: string
        if (!is_null($serverId) && !is_string($serverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverId, true), gettype($serverId)), __LINE__);
        }
        $this->ServerId = $serverId;
        return $this;
    }
    /**
     * Get ProviderName value
     * @return string|null
     */
    public function getProviderName()
    {
        return $this->ProviderName;
    }
    /**
     * Set ProviderName value
     * @param string $providerName
     * @return \StructType\Login
     */
    public function setProviderName($providerName = null)
    {
        // validation for constraint: string
        if (!is_null($providerName) && !is_string($providerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerName, true), gettype($providerName)), __LINE__);
        }
        $this->ProviderName = $providerName;
        return $this;
    }
    /**
     * Get DPEServer value
     * @return string|null
     */
    public function getDPEServer()
    {
        return $this->DPEServer;
    }
    /**
     * Set DPEServer value
     * @param string $dPEServer
     * @return \StructType\Login
     */
    public function setDPEServer($dPEServer = null)
    {
        // validation for constraint: string
        if (!is_null($dPEServer) && !is_string($dPEServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dPEServer, true), gettype($dPEServer)), __LINE__);
        }
        $this->DPEServer = $dPEServer;
        return $this;
    }
    /**
     * Get PortNo value
     * @return string|null
     */
    public function getPortNo()
    {
        return $this->PortNo;
    }
    /**
     * Set PortNo value
     * @param string $portNo
     * @return \StructType\Login
     */
    public function setPortNo($portNo = null)
    {
        // validation for constraint: string
        if (!is_null($portNo) && !is_string($portNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portNo, true), gettype($portNo)), __LINE__);
        }
        $this->PortNo = $portNo;
        return $this;
    }
    /**
     * Get DBName value
     * @return string|null
     */
    public function getDBName()
    {
        return $this->DBName;
    }
    /**
     * Set DBName value
     * @param string $dBName
     * @return \StructType\Login
     */
    public function setDBName($dBName = null)
    {
        // validation for constraint: string
        if (!is_null($dBName) && !is_string($dBName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dBName, true), gettype($dBName)), __LINE__);
        }
        $this->DBName = $dBName;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\Login
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Login
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ERPServer value
     * @return string|null
     */
    public function getERPServer()
    {
        return $this->ERPServer;
    }
    /**
     * Set ERPServer value
     * @param string $eRPServer
     * @return \StructType\Login
     */
    public function setERPServer($eRPServer = null)
    {
        // validation for constraint: string
        if (!is_null($eRPServer) && !is_string($eRPServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRPServer, true), gettype($eRPServer)), __LINE__);
        }
        $this->ERPServer = $eRPServer;
        return $this;
    }
    /**
     * Get ERPDatabase value
     * @return string|null
     */
    public function getERPDatabase()
    {
        return $this->ERPDatabase;
    }
    /**
     * Set ERPDatabase value
     * @param string $eRPDatabase
     * @return \StructType\Login
     */
    public function setERPDatabase($eRPDatabase = null)
    {
        // validation for constraint: string
        if (!is_null($eRPDatabase) && !is_string($eRPDatabase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRPDatabase, true), gettype($eRPDatabase)), __LINE__);
        }
        $this->ERPDatabase = $eRPDatabase;
        return $this;
    }
    /**
     * Get ERPUserID value
     * @return string|null
     */
    public function getERPUserID()
    {
        return $this->ERPUserID;
    }
    /**
     * Set ERPUserID value
     * @param string $eRPUserID
     * @return \StructType\Login
     */
    public function setERPUserID($eRPUserID = null)
    {
        // validation for constraint: string
        if (!is_null($eRPUserID) && !is_string($eRPUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRPUserID, true), gettype($eRPUserID)), __LINE__);
        }
        $this->ERPUserID = $eRPUserID;
        return $this;
    }
    /**
     * Get ERPPassword value
     * @return string|null
     */
    public function getERPPassword()
    {
        return $this->ERPPassword;
    }
    /**
     * Set ERPPassword value
     * @param string $eRPPassword
     * @return \StructType\Login
     */
    public function setERPPassword($eRPPassword = null)
    {
        // validation for constraint: string
        if (!is_null($eRPPassword) && !is_string($eRPPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRPPassword, true), gettype($eRPPassword)), __LINE__);
        }
        $this->ERPPassword = $eRPPassword;
        return $this;
    }
}
