<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Client ServiceType
 * @subpackage Services
 */
class Client extends AbstractSoapClientBase
{
    /**
     * Sets the Login SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Login $login
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLogin(\StructType\Login $login, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Login', $login, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ClientLogin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Login
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Login
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ClientLogin $parameters
     * @return \StructType\ClientLoginResponse|bool
     */
    public function ClientLogin(\StructType\ClientLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ClientLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ClientLoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
