<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for StatusCode EnumType
 * @subpackage Enumerations
 */
class StatusCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Offline'
     * @return string 'Offline'
     */
    const VALUE_OFFLINE = 'Offline';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Accept'
     * @return string 'Accept'
     */
    const VALUE_ACCEPT = 'Accept';
    /**
     * Constant for value 'Reject'
     * @return string 'Reject'
     */
    const VALUE_REJECT = 'Reject';
    /**
     * Constant for value 'TimeOut'
     * @return string 'TimeOut'
     */
    const VALUE_TIME_OUT = 'TimeOut';
    /**
     * Constant for value 'DbError'
     * @return string 'DbError'
     */
    const VALUE_DB_ERROR = 'DbError';
    /**
     * Constant for value 'BuyClose'
     * @return string 'BuyClose'
     */
    const VALUE_BUY_CLOSE = 'BuyClose';
    /**
     * Constant for value 'SellClose'
     * @return string 'SellClose'
     */
    const VALUE_SELL_CLOSE = 'SellClose';
    /**
     * Constant for value 'TradeClose'
     * @return string 'TradeClose'
     */
    const VALUE_TRADE_CLOSE = 'TradeClose';
    /**
     * Constant for value 'LimitExceeded'
     * @return string 'LimitExceeded'
     */
    const VALUE_LIMIT_EXCEEDED = 'LimitExceeded';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_OFFLINE
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_ACCEPT
     * @uses self::VALUE_REJECT
     * @uses self::VALUE_TIME_OUT
     * @uses self::VALUE_DB_ERROR
     * @uses self::VALUE_BUY_CLOSE
     * @uses self::VALUE_SELL_CLOSE
     * @uses self::VALUE_TRADE_CLOSE
     * @uses self::VALUE_LIMIT_EXCEEDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_OFFLINE,
            self::VALUE_PENDING,
            self::VALUE_ACCEPT,
            self::VALUE_REJECT,
            self::VALUE_TIME_OUT,
            self::VALUE_DB_ERROR,
            self::VALUE_BUY_CLOSE,
            self::VALUE_SELL_CLOSE,
            self::VALUE_TRADE_CLOSE,
            self::VALUE_LIMIT_EXCEEDED,
        );
    }
}
