<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Login SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Login $login
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLogin(\StructType\Login $login, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Login', $login, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Login
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Login
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAccount $parameters
     * @return \StructType\CreateAccountResponse|bool
     */
    public function CreateAccount(\StructType\CreateAccount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateAccountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
