<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendOrder StructType
 * @subpackage Structs
 */
class SendOrder extends AbstractStructBase
{
    /**
     * The CmdType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CmdType;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductId;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The Terminal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Terminal;
    /**
     * The TerminalPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TerminalPassword;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Token;
    /**
     * Constructor method for SendOrder
     * @uses SendOrder::setCmdType()
     * @uses SendOrder::setProductId()
     * @uses SendOrder::setAmount()
     * @uses SendOrder::setTerminal()
     * @uses SendOrder::setTerminalPassword()
     * @uses SendOrder::setToken()
     * @param int $cmdType
     * @param int $productId
     * @param float $amount
     * @param string $terminal
     * @param string $terminalPassword
     * @param string $token
     */
    public function __construct($cmdType = null, $productId = null, $amount = null, $terminal = null, $terminalPassword = null, $token = null)
    {
        $this
            ->setCmdType($cmdType)
            ->setProductId($productId)
            ->setAmount($amount)
            ->setTerminal($terminal)
            ->setTerminalPassword($terminalPassword)
            ->setToken($token);
    }
    /**
     * Get CmdType value
     * @return int
     */
    public function getCmdType()
    {
        return $this->CmdType;
    }
    /**
     * Set CmdType value
     * @param int $cmdType
     * @return \StructType\SendOrder
     */
    public function setCmdType($cmdType = null)
    {
        // validation for constraint: int
        if (!is_null($cmdType) && !(is_int($cmdType) || ctype_digit($cmdType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cmdType, true), gettype($cmdType)), __LINE__);
        }
        $this->CmdType = $cmdType;
        return $this;
    }
    /**
     * Get ProductId value
     * @return int
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\SendOrder
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SendOrder
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \StructType\SendOrder
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminal, true), gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get TerminalPassword value
     * @return string|null
     */
    public function getTerminalPassword()
    {
        return $this->TerminalPassword;
    }
    /**
     * Set TerminalPassword value
     * @param string $terminalPassword
     * @return \StructType\SendOrder
     */
    public function setTerminalPassword($terminalPassword = null)
    {
        // validation for constraint: string
        if (!is_null($terminalPassword) && !is_string($terminalPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalPassword, true), gettype($terminalPassword)), __LINE__);
        }
        $this->TerminalPassword = $terminalPassword;
        return $this;
    }
    /**
     * Get Token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->Token;
    }
    /**
     * Set Token value
     * @param string $token
     * @return \StructType\SendOrder
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->Token = $token;
        return $this;
    }
}
