<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Sets the Login SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Login $login
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLogin(\StructType\Login $login, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Login', $login, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SendOrder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Login
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Login
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendOrder $parameters
     * @return \StructType\SendOrderResponse|bool
     */
    public function SendOrder(\StructType\SendOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
