<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Login SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Login $login
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLogin(\StructType\Login $login, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Login', $login, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetErpMembers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Login
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Login
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetErpMembers $parameters
     * @return \StructType\GetErpMembersResponse|bool
     */
    public function GetErpMembers(\StructType\GetErpMembers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetErpMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFXProducts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Login
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Login
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFXProducts $parameters
     * @return \StructType\GetFXProductsResponse|bool
     */
    public function GetFXProducts(\StructType\GetFXProducts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFXProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFXOrders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Login
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Login
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFXOrders $parameters
     * @return \StructType\GetFXOrdersResponse|bool
     */
    public function GetFXOrders(\StructType\GetFXOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFXOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFXMembers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Login
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Login
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFXMembers $parameters
     * @return \StructType\GetFXMembersResponse|bool
     */
    public function GetFXMembers(\StructType\GetFXMembers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFXMembers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFXERPBalances
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Login
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \StructType\Login
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFXERPBalances $parameters
     * @return \StructType\GetFXERPBalancesResponse|bool
     */
    public function GetFXERPBalances(\StructType\GetFXERPBalances $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFXERPBalances($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetErpMembersResponse|\StructType\GetFXERPBalancesResponse|\StructType\GetFXMembersResponse|\StructType\GetFXOrdersResponse|\StructType\GetFXProductsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
