<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerProductBrandGroup StructType
 * @subpackage Structs
 */
class CustomerProductBrandGroup extends AbstractStructBase
{
    /**
     * The customer_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customer_code;
    /**
     * The cari_kod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cari_kod;
    /**
     * The scode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scode;
    /**
     * The marka
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $marka;
    /**
     * The grup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $grup;
    /**
     * Constructor method for CustomerProductBrandGroup
     * @uses CustomerProductBrandGroup::setCustomer_code()
     * @uses CustomerProductBrandGroup::setCari_kod()
     * @uses CustomerProductBrandGroup::setScode()
     * @uses CustomerProductBrandGroup::setMarka()
     * @uses CustomerProductBrandGroup::setGrup()
     * @param string $customer_code
     * @param string $cari_kod
     * @param string $scode
     * @param string $marka
     * @param string $grup
     */
    public function __construct($customer_code = null, $cari_kod = null, $scode = null, $marka = null, $grup = null)
    {
        $this
            ->setCustomer_code($customer_code)
            ->setCari_kod($cari_kod)
            ->setScode($scode)
            ->setMarka($marka)
            ->setGrup($grup);
    }
    /**
     * Get customer_code value
     * @return string|null
     */
    public function getCustomer_code()
    {
        return $this->customer_code;
    }
    /**
     * Set customer_code value
     * @param string $customer_code
     * @return \StructType\CustomerProductBrandGroup
     */
    public function setCustomer_code($customer_code = null)
    {
        // validation for constraint: string
        if (!is_null($customer_code) && !is_string($customer_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_code, true), gettype($customer_code)), __LINE__);
        }
        $this->customer_code = $customer_code;
        return $this;
    }
    /**
     * Get cari_kod value
     * @return string|null
     */
    public function getCari_kod()
    {
        return $this->cari_kod;
    }
    /**
     * Set cari_kod value
     * @param string $cari_kod
     * @return \StructType\CustomerProductBrandGroup
     */
    public function setCari_kod($cari_kod = null)
    {
        // validation for constraint: string
        if (!is_null($cari_kod) && !is_string($cari_kod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cari_kod, true), gettype($cari_kod)), __LINE__);
        }
        $this->cari_kod = $cari_kod;
        return $this;
    }
    /**
     * Get scode value
     * @return string|null
     */
    public function getScode()
    {
        return $this->scode;
    }
    /**
     * Set scode value
     * @param string $scode
     * @return \StructType\CustomerProductBrandGroup
     */
    public function setScode($scode = null)
    {
        // validation for constraint: string
        if (!is_null($scode) && !is_string($scode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scode, true), gettype($scode)), __LINE__);
        }
        $this->scode = $scode;
        return $this;
    }
    /**
     * Get marka value
     * @return string|null
     */
    public function getMarka()
    {
        return $this->marka;
    }
    /**
     * Set marka value
     * @param string $marka
     * @return \StructType\CustomerProductBrandGroup
     */
    public function setMarka($marka = null)
    {
        // validation for constraint: string
        if (!is_null($marka) && !is_string($marka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marka, true), gettype($marka)), __LINE__);
        }
        $this->marka = $marka;
        return $this;
    }
    /**
     * Get grup value
     * @return string|null
     */
    public function getGrup()
    {
        return $this->grup;
    }
    /**
     * Set grup value
     * @param string $grup
     * @return \StructType\CustomerProductBrandGroup
     */
    public function setGrup($grup = null)
    {
        // validation for constraint: string
        if (!is_null($grup) && !is_string($grup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grup, true), gettype($grup)), __LINE__);
        }
        $this->grup = $grup;
        return $this;
    }
}
