<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Model ServiceType
 * @subpackage Services
 */
class Model extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ModelList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ModelList $parameters
     * @return \StructType\ModelListResponse|bool
     */
    public function ModelList(\StructType\ModelList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ModelList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ModelListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
