<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Marka ServiceType
 * @subpackage Services
 */
class Marka extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MarkaList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkaList $parameters
     * @return \StructType\MarkaListResponse|bool
     */
    public function MarkaList(\StructType\MarkaList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkaList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MarkaListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
