<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Grup ServiceType
 * @subpackage Services
 */
class Grup extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GrupList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrupList $parameters
     * @return \StructType\GrupListResponse|bool
     */
    public function GrupList(\StructType\GrupList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GrupList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GrupListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
