<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://customer.meydangroup.com.tr/customertech.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://customer.meydangroup.com.tr/customertech.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Customer ServiceType
 */
$customer = new \ServiceType\Customer($options);
/**
 * Sample call for CustomerProduct operation/method
 */
if ($customer->CustomerProduct(new \StructType\CustomerProduct()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for CustomerProductBranch operation/method
 */
if ($customer->CustomerProductBranch(new \StructType\CustomerProductBranch()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for CustomerProductTest operation/method
 */
if ($customer->CustomerProductTest(new \StructType\CustomerProductTest()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for CustomerExch operation/method
 */
if ($customer->CustomerExch(new \StructType\CustomerExch()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for CustomerProductBrand operation/method
 */
if ($customer->CustomerProductBrand(new \StructType\CustomerProductBrand()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for CustomerProductGroup operation/method
 */
if ($customer->CustomerProductGroup(new \StructType\CustomerProductGroup()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Sample call for CustomerProductBrandGroup operation/method
 */
if ($customer->CustomerProductBrandGroup(new \StructType\CustomerProductBrandGroup()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Samples for Marka ServiceType
 */
$marka = new \ServiceType\Marka($options);
/**
 * Sample call for MarkaList operation/method
 */
if ($marka->MarkaList(new \StructType\MarkaList()) !== false) {
    print_r($marka->getResult());
} else {
    print_r($marka->getLastError());
}
/**
 * Samples for Model ServiceType
 */
$model = new \ServiceType\Model($options);
/**
 * Sample call for ModelList operation/method
 */
if ($model->ModelList(new \StructType\ModelList()) !== false) {
    print_r($model->getResult());
} else {
    print_r($model->getLastError());
}
/**
 * Samples for Grup ServiceType
 */
$grup = new \ServiceType\Grup($options);
/**
 * Sample call for GrupList operation/method
 */
if ($grup->GrupList(new \StructType\GrupList()) !== false) {
    print_r($grup->getResult());
} else {
    print_r($grup->getLastError());
}
/**
 * Samples for Alt ServiceType
 */
$alt = new \ServiceType\Alt($options);
/**
 * Sample call for AltGrupList operation/method
 */
if ($alt->AltGrupList(new \StructType\AltGrupList()) !== false) {
    print_r($alt->getResult());
} else {
    print_r($alt->getLastError());
}
