<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerProductGroup StructType
 * @subpackage Structs
 */
class CustomerProductGroup extends AbstractStructBase
{
    /**
     * The customer_code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customer_code;
    /**
     * The cari_kod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cari_kod;
    /**
     * The scode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scode;
    /**
     * The grup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $grup;
    /**
     * Constructor method for CustomerProductGroup
     * @uses CustomerProductGroup::setCustomer_code()
     * @uses CustomerProductGroup::setCari_kod()
     * @uses CustomerProductGroup::setScode()
     * @uses CustomerProductGroup::setGrup()
     * @param string $customer_code
     * @param string $cari_kod
     * @param string $scode
     * @param string $grup
     */
    public function __construct($customer_code = null, $cari_kod = null, $scode = null, $grup = null)
    {
        $this
            ->setCustomer_code($customer_code)
            ->setCari_kod($cari_kod)
            ->setScode($scode)
            ->setGrup($grup);
    }
    /**
     * Get customer_code value
     * @return string|null
     */
    public function getCustomer_code()
    {
        return $this->customer_code;
    }
    /**
     * Set customer_code value
     * @param string $customer_code
     * @return \StructType\CustomerProductGroup
     */
    public function setCustomer_code($customer_code = null)
    {
        // validation for constraint: string
        if (!is_null($customer_code) && !is_string($customer_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_code, true), gettype($customer_code)), __LINE__);
        }
        $this->customer_code = $customer_code;
        return $this;
    }
    /**
     * Get cari_kod value
     * @return string|null
     */
    public function getCari_kod()
    {
        return $this->cari_kod;
    }
    /**
     * Set cari_kod value
     * @param string $cari_kod
     * @return \StructType\CustomerProductGroup
     */
    public function setCari_kod($cari_kod = null)
    {
        // validation for constraint: string
        if (!is_null($cari_kod) && !is_string($cari_kod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cari_kod, true), gettype($cari_kod)), __LINE__);
        }
        $this->cari_kod = $cari_kod;
        return $this;
    }
    /**
     * Get scode value
     * @return string|null
     */
    public function getScode()
    {
        return $this->scode;
    }
    /**
     * Set scode value
     * @param string $scode
     * @return \StructType\CustomerProductGroup
     */
    public function setScode($scode = null)
    {
        // validation for constraint: string
        if (!is_null($scode) && !is_string($scode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scode, true), gettype($scode)), __LINE__);
        }
        $this->scode = $scode;
        return $this;
    }
    /**
     * Get grup value
     * @return string|null
     */
    public function getGrup()
    {
        return $this->grup;
    }
    /**
     * Set grup value
     * @param string $grup
     * @return \StructType\CustomerProductGroup
     */
    public function setGrup($grup = null)
    {
        // validation for constraint: string
        if (!is_null($grup) && !is_string($grup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grup, true), gettype($grup)), __LINE__);
        }
        $this->grup = $grup;
        return $this;
    }
}
