<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CustomerProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerProduct $parameters
     * @return \StructType\CustomerProductResponse|bool
     */
    public function CustomerProduct(\StructType\CustomerProduct $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CustomerProductBranch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerProductBranch $parameters
     * @return \StructType\CustomerProductBranchResponse|bool
     */
    public function CustomerProductBranch(\StructType\CustomerProductBranch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerProductBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CustomerProductTest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerProductTest $parameters
     * @return \StructType\CustomerProductTestResponse|bool
     */
    public function CustomerProductTest(\StructType\CustomerProductTest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerProductTest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CustomerExch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerExch $parameters
     * @return \StructType\CustomerExchResponse|bool
     */
    public function CustomerExch(\StructType\CustomerExch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerExch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CustomerProductBrand
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerProductBrand $parameters
     * @return \StructType\CustomerProductBrandResponse|bool
     */
    public function CustomerProductBrand(\StructType\CustomerProductBrand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerProductBrand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CustomerProductGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerProductGroup $parameters
     * @return \StructType\CustomerProductGroupResponse|bool
     */
    public function CustomerProductGroup(\StructType\CustomerProductGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerProductGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CustomerProductBrandGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerProductBrandGroup $parameters
     * @return \StructType\CustomerProductBrandGroupResponse|bool
     */
    public function CustomerProductBrandGroup(\StructType\CustomerProductBrandGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerProductBrandGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CustomerExchResponse|\StructType\CustomerProductBranchResponse|\StructType\CustomerProductBrandGroupResponse|\StructType\CustomerProductBrandResponse|\StructType\CustomerProductGroupResponse|\StructType\CustomerProductResponse|\StructType\CustomerProductTestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
