<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tokenRequest StructType
 * @subpackage Structs
 */
class TokenRequest extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The constructionGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $constructionGroup;
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderId;
    /**
     * Constructor method for tokenRequest
     * @uses TokenRequest::setAmount()
     * @uses TokenRequest::setConstructionGroup()
     * @uses TokenRequest::setOrderId()
     * @param int $amount
     * @param int $constructionGroup
     * @param string $orderId
     */
    public function __construct($amount = null, $constructionGroup = null, $orderId = null)
    {
        $this
            ->setAmount($amount)
            ->setConstructionGroup($constructionGroup)
            ->setOrderId($orderId);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\TokenRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get constructionGroup value
     * @return int
     */
    public function getConstructionGroup()
    {
        return $this->constructionGroup;
    }
    /**
     * Set constructionGroup value
     * @param int $constructionGroup
     * @return \StructType\TokenRequest
     */
    public function setConstructionGroup($constructionGroup = null)
    {
        // validation for constraint: int
        if (!is_null($constructionGroup) && !(is_int($constructionGroup) || ctype_digit($constructionGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($constructionGroup, true), gettype($constructionGroup)), __LINE__);
        }
        $this->constructionGroup = $constructionGroup;
        return $this;
    }
    /**
     * Get orderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param string $orderId
     * @return \StructType\TokenRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
}
