<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tokenResponse StructType
 * @subpackage Structs
 */
class TokenResponse extends AbstractStructBase
{
    /**
     * The loginUrl
     * @var string
     */
    public $loginUrl;
    /**
     * The appId
     * @var int
     */
    public $appId;
    /**
     * Constructor method for tokenResponse
     * @uses TokenResponse::setLoginUrl()
     * @uses TokenResponse::setAppId()
     * @param string $loginUrl
     * @param int $appId
     */
    public function __construct($loginUrl = null, $appId = null)
    {
        $this
            ->setLoginUrl($loginUrl)
            ->setAppId($appId);
    }
    /**
     * Get loginUrl value
     * @return string|null
     */
    public function getLoginUrl()
    {
        return $this->loginUrl;
    }
    /**
     * Set loginUrl value
     * @param string $loginUrl
     * @return \StructType\TokenResponse
     */
    public function setLoginUrl($loginUrl = null)
    {
        // validation for constraint: string
        if (!is_null($loginUrl) && !is_string($loginUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginUrl, true), gettype($loginUrl)), __LINE__);
        }
        $this->loginUrl = $loginUrl;
        return $this;
    }
    /**
     * Get appId value
     * @return int|null
     */
    public function getAppId()
    {
        return $this->appId;
    }
    /**
     * Set appId value
     * @param int $appId
     * @return \StructType\TokenResponse
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: int
        if (!is_null($appId) && !(is_int($appId) || ctype_digit($appId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        $this->appId = $appId;
        return $this;
    }
}
