<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stornoResponse StructType
 * @subpackage Structs
 */
class StornoResponse extends AbstractStructBase
{
    /**
     * The appId
     * @var int
     */
    public $appId;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for stornoResponse
     * @uses StornoResponse::setAppId()
     * @uses StornoResponse::setStatus()
     * @param int $appId
     * @param string $status
     */
    public function __construct($appId = null, $status = null)
    {
        $this
            ->setAppId($appId)
            ->setStatus($status);
    }
    /**
     * Get appId value
     * @return int|null
     */
    public function getAppId()
    {
        return $this->appId;
    }
    /**
     * Set appId value
     * @param int $appId
     * @return \StructType\StornoResponse
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: int
        if (!is_null($appId) && !(is_int($appId) || ctype_digit($appId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        $this->appId = $appId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\StornoResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
