<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for report StructType
 * @subpackage Structs
 */
class Report extends AbstractStructBase
{
    /**
     * The appId
     * @var int
     */
    public $appId;
    /**
     * The applicantName
     * @var string
     */
    public $applicantName;
    /**
     * The appBeginDate
     * @var string
     */
    public $appBeginDate;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The productDeliverable
     * @var bool
     */
    public $productDeliverable;
    /**
     * The creditAmount
     * @var int
     */
    public $creditAmount;
    /**
     * The contribution
     * @var int
     */
    public $contribution;
    /**
     * The orderId
     * @var string
     */
    public $orderId;
    /**
     * The bankAccNo
     * @var string
     */
    public $bankAccNo;
    /**
     * The contractPosNm
     * @var string
     */
    public $contractPosNm;
    /**
     * The salesPointCode
     * @var string
     */
    public $salesPointCode;
    /**
     * The salesPointName
     * @var string
     */
    public $salesPointName;
    /**
     * The giroTransactionDate
     * @var string
     */
    public $giroTransactionDate;
    /**
     * The bankAccountNumber
     * @var string
     */
    public $bankAccountNumber;
    /**
     * The accountType
     * @var string
     */
    public $accountType;
    /**
     * The loanAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $loanAmount;
    /**
     * The ownFundsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ownFundsAmount;
    /**
     * The purchaseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $purchaseAmount;
    /**
     * The merchenaryFeeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $merchenaryFeeAmount;
    /**
     * The transactionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $transactionAmount;
    /**
     * Constructor method for report
     * @uses Report::setAppId()
     * @uses Report::setApplicantName()
     * @uses Report::setAppBeginDate()
     * @uses Report::setStatus()
     * @uses Report::setProductDeliverable()
     * @uses Report::setCreditAmount()
     * @uses Report::setContribution()
     * @uses Report::setOrderId()
     * @uses Report::setBankAccNo()
     * @uses Report::setContractPosNm()
     * @uses Report::setSalesPointCode()
     * @uses Report::setSalesPointName()
     * @uses Report::setGiroTransactionDate()
     * @uses Report::setBankAccountNumber()
     * @uses Report::setAccountType()
     * @uses Report::setLoanAmount()
     * @uses Report::setOwnFundsAmount()
     * @uses Report::setPurchaseAmount()
     * @uses Report::setMerchenaryFeeAmount()
     * @uses Report::setTransactionAmount()
     * @param int $appId
     * @param string $applicantName
     * @param string $appBeginDate
     * @param string $status
     * @param bool $productDeliverable
     * @param int $creditAmount
     * @param int $contribution
     * @param string $orderId
     * @param string $bankAccNo
     * @param string $contractPosNm
     * @param string $salesPointCode
     * @param string $salesPointName
     * @param string $giroTransactionDate
     * @param string $bankAccountNumber
     * @param string $accountType
     * @param float $loanAmount
     * @param float $ownFundsAmount
     * @param float $purchaseAmount
     * @param float $merchenaryFeeAmount
     * @param float $transactionAmount
     */
    public function __construct($appId = null, $applicantName = null, $appBeginDate = null, $status = null, $productDeliverable = null, $creditAmount = null, $contribution = null, $orderId = null, $bankAccNo = null, $contractPosNm = null, $salesPointCode = null, $salesPointName = null, $giroTransactionDate = null, $bankAccountNumber = null, $accountType = null, $loanAmount = null, $ownFundsAmount = null, $purchaseAmount = null, $merchenaryFeeAmount = null, $transactionAmount = null)
    {
        $this
            ->setAppId($appId)
            ->setApplicantName($applicantName)
            ->setAppBeginDate($appBeginDate)
            ->setStatus($status)
            ->setProductDeliverable($productDeliverable)
            ->setCreditAmount($creditAmount)
            ->setContribution($contribution)
            ->setOrderId($orderId)
            ->setBankAccNo($bankAccNo)
            ->setContractPosNm($contractPosNm)
            ->setSalesPointCode($salesPointCode)
            ->setSalesPointName($salesPointName)
            ->setGiroTransactionDate($giroTransactionDate)
            ->setBankAccountNumber($bankAccountNumber)
            ->setAccountType($accountType)
            ->setLoanAmount($loanAmount)
            ->setOwnFundsAmount($ownFundsAmount)
            ->setPurchaseAmount($purchaseAmount)
            ->setMerchenaryFeeAmount($merchenaryFeeAmount)
            ->setTransactionAmount($transactionAmount);
    }
    /**
     * Get appId value
     * @return int|null
     */
    public function getAppId()
    {
        return $this->appId;
    }
    /**
     * Set appId value
     * @param int $appId
     * @return \StructType\Report
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: int
        if (!is_null($appId) && !(is_int($appId) || ctype_digit($appId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        $this->appId = $appId;
        return $this;
    }
    /**
     * Get applicantName value
     * @return string|null
     */
    public function getApplicantName()
    {
        return $this->applicantName;
    }
    /**
     * Set applicantName value
     * @param string $applicantName
     * @return \StructType\Report
     */
    public function setApplicantName($applicantName = null)
    {
        // validation for constraint: string
        if (!is_null($applicantName) && !is_string($applicantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicantName, true), gettype($applicantName)), __LINE__);
        }
        $this->applicantName = $applicantName;
        return $this;
    }
    /**
     * Get appBeginDate value
     * @return string|null
     */
    public function getAppBeginDate()
    {
        return $this->appBeginDate;
    }
    /**
     * Set appBeginDate value
     * @param string $appBeginDate
     * @return \StructType\Report
     */
    public function setAppBeginDate($appBeginDate = null)
    {
        // validation for constraint: string
        if (!is_null($appBeginDate) && !is_string($appBeginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appBeginDate, true), gettype($appBeginDate)), __LINE__);
        }
        $this->appBeginDate = $appBeginDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Report
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get productDeliverable value
     * @return bool|null
     */
    public function getProductDeliverable()
    {
        return $this->productDeliverable;
    }
    /**
     * Set productDeliverable value
     * @param bool $productDeliverable
     * @return \StructType\Report
     */
    public function setProductDeliverable($productDeliverable = null)
    {
        // validation for constraint: boolean
        if (!is_null($productDeliverable) && !is_bool($productDeliverable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($productDeliverable, true), gettype($productDeliverable)), __LINE__);
        }
        $this->productDeliverable = $productDeliverable;
        return $this;
    }
    /**
     * Get creditAmount value
     * @return int|null
     */
    public function getCreditAmount()
    {
        return $this->creditAmount;
    }
    /**
     * Set creditAmount value
     * @param int $creditAmount
     * @return \StructType\Report
     */
    public function setCreditAmount($creditAmount = null)
    {
        // validation for constraint: int
        if (!is_null($creditAmount) && !(is_int($creditAmount) || ctype_digit($creditAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditAmount, true), gettype($creditAmount)), __LINE__);
        }
        $this->creditAmount = $creditAmount;
        return $this;
    }
    /**
     * Get contribution value
     * @return int|null
     */
    public function getContribution()
    {
        return $this->contribution;
    }
    /**
     * Set contribution value
     * @param int $contribution
     * @return \StructType\Report
     */
    public function setContribution($contribution = null)
    {
        // validation for constraint: int
        if (!is_null($contribution) && !(is_int($contribution) || ctype_digit($contribution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contribution, true), gettype($contribution)), __LINE__);
        }
        $this->contribution = $contribution;
        return $this;
    }
    /**
     * Get orderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param string $orderId
     * @return \StructType\Report
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get bankAccNo value
     * @return string|null
     */
    public function getBankAccNo()
    {
        return $this->bankAccNo;
    }
    /**
     * Set bankAccNo value
     * @param string $bankAccNo
     * @return \StructType\Report
     */
    public function setBankAccNo($bankAccNo = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccNo) && !is_string($bankAccNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccNo, true), gettype($bankAccNo)), __LINE__);
        }
        $this->bankAccNo = $bankAccNo;
        return $this;
    }
    /**
     * Get contractPosNm value
     * @return string|null
     */
    public function getContractPosNm()
    {
        return $this->contractPosNm;
    }
    /**
     * Set contractPosNm value
     * @param string $contractPosNm
     * @return \StructType\Report
     */
    public function setContractPosNm($contractPosNm = null)
    {
        // validation for constraint: string
        if (!is_null($contractPosNm) && !is_string($contractPosNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractPosNm, true), gettype($contractPosNm)), __LINE__);
        }
        $this->contractPosNm = $contractPosNm;
        return $this;
    }
    /**
     * Get salesPointCode value
     * @return string|null
     */
    public function getSalesPointCode()
    {
        return $this->salesPointCode;
    }
    /**
     * Set salesPointCode value
     * @param string $salesPointCode
     * @return \StructType\Report
     */
    public function setSalesPointCode($salesPointCode = null)
    {
        // validation for constraint: string
        if (!is_null($salesPointCode) && !is_string($salesPointCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPointCode, true), gettype($salesPointCode)), __LINE__);
        }
        $this->salesPointCode = $salesPointCode;
        return $this;
    }
    /**
     * Get salesPointName value
     * @return string|null
     */
    public function getSalesPointName()
    {
        return $this->salesPointName;
    }
    /**
     * Set salesPointName value
     * @param string $salesPointName
     * @return \StructType\Report
     */
    public function setSalesPointName($salesPointName = null)
    {
        // validation for constraint: string
        if (!is_null($salesPointName) && !is_string($salesPointName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesPointName, true), gettype($salesPointName)), __LINE__);
        }
        $this->salesPointName = $salesPointName;
        return $this;
    }
    /**
     * Get giroTransactionDate value
     * @return string|null
     */
    public function getGiroTransactionDate()
    {
        return $this->giroTransactionDate;
    }
    /**
     * Set giroTransactionDate value
     * @param string $giroTransactionDate
     * @return \StructType\Report
     */
    public function setGiroTransactionDate($giroTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($giroTransactionDate) && !is_string($giroTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giroTransactionDate, true), gettype($giroTransactionDate)), __LINE__);
        }
        $this->giroTransactionDate = $giroTransactionDate;
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \StructType\Report
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountNumber, true), gettype($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get accountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @param string $accountType
     * @return \StructType\Report
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get loanAmount value
     * @return float|null
     */
    public function getLoanAmount()
    {
        return $this->loanAmount;
    }
    /**
     * Set loanAmount value
     * @param float $loanAmount
     * @return \StructType\Report
     */
    public function setLoanAmount($loanAmount = null)
    {
        // validation for constraint: float
        if (!is_null($loanAmount) && !(is_float($loanAmount) || is_numeric($loanAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loanAmount, true), gettype($loanAmount)), __LINE__);
        }
        $this->loanAmount = $loanAmount;
        return $this;
    }
    /**
     * Get ownFundsAmount value
     * @return float|null
     */
    public function getOwnFundsAmount()
    {
        return $this->ownFundsAmount;
    }
    /**
     * Set ownFundsAmount value
     * @param float $ownFundsAmount
     * @return \StructType\Report
     */
    public function setOwnFundsAmount($ownFundsAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ownFundsAmount) && !(is_float($ownFundsAmount) || is_numeric($ownFundsAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ownFundsAmount, true), gettype($ownFundsAmount)), __LINE__);
        }
        $this->ownFundsAmount = $ownFundsAmount;
        return $this;
    }
    /**
     * Get purchaseAmount value
     * @return float|null
     */
    public function getPurchaseAmount()
    {
        return $this->purchaseAmount;
    }
    /**
     * Set purchaseAmount value
     * @param float $purchaseAmount
     * @return \StructType\Report
     */
    public function setPurchaseAmount($purchaseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($purchaseAmount) && !(is_float($purchaseAmount) || is_numeric($purchaseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchaseAmount, true), gettype($purchaseAmount)), __LINE__);
        }
        $this->purchaseAmount = $purchaseAmount;
        return $this;
    }
    /**
     * Get merchenaryFeeAmount value
     * @return float|null
     */
    public function getMerchenaryFeeAmount()
    {
        return $this->merchenaryFeeAmount;
    }
    /**
     * Set merchenaryFeeAmount value
     * @param float $merchenaryFeeAmount
     * @return \StructType\Report
     */
    public function setMerchenaryFeeAmount($merchenaryFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($merchenaryFeeAmount) && !(is_float($merchenaryFeeAmount) || is_numeric($merchenaryFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($merchenaryFeeAmount, true), gettype($merchenaryFeeAmount)), __LINE__);
        }
        $this->merchenaryFeeAmount = $merchenaryFeeAmount;
        return $this;
    }
    /**
     * Get transactionAmount value
     * @return float|null
     */
    public function getTransactionAmount()
    {
        return $this->transactionAmount;
    }
    /**
     * Set transactionAmount value
     * @param float $transactionAmount
     * @return \StructType\Report
     */
    public function setTransactionAmount($transactionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($transactionAmount) && !(is_float($transactionAmount) || is_numeric($transactionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transactionAmount, true), gettype($transactionAmount)), __LINE__);
        }
        $this->transactionAmount = $transactionAmount;
        return $this;
    }
}
