<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Token ServiceType
 * @subpackage Services
 */
class Token extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named token
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TokenRequest $tokenRequest
     * @return \StructType\TokenResponse|bool
     */
    public function token(\StructType\TokenRequest $tokenRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->token($tokenRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
