<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Storno ServiceType
 * @subpackage Services
 */
class Storno extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named storno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StornoRequest $stornoRequest
     * @return \StructType\StornoResponse|bool
     */
    public function storno(\StructType\StornoRequest $stornoRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->storno($stornoRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StornoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
