<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for giroReportResponse StructType
 * @subpackage Structs
 */
class GiroReportResponse extends AbstractStructBase
{
    /**
     * The report
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Report[]
     */
    public $report;
    /**
     * Constructor method for giroReportResponse
     * @uses GiroReportResponse::setReport()
     * @param \StructType\Report[] $report
     */
    public function __construct(array $report = array())
    {
        $this
            ->setReport($report);
    }
    /**
     * Get report value
     * @return \StructType\Report[]|null
     */
    public function getReport()
    {
        return $this->report;
    }
    /**
     * This method is responsible for validating the values passed to the setReport method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReport method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReportForArrayConstraintsFromSetReport(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giroReportResponseReportItem) {
            // validation for constraint: itemType
            if (!$giroReportResponseReportItem instanceof \StructType\Report) {
                $invalidValues[] = is_object($giroReportResponseReportItem) ? get_class($giroReportResponseReportItem) : sprintf('%s(%s)', gettype($giroReportResponseReportItem), var_export($giroReportResponseReportItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The report property can only contain items of type \StructType\Report, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set report value
     * @throws \InvalidArgumentException
     * @param \StructType\Report[] $report
     * @return \StructType\GiroReportResponse
     */
    public function setReport(array $report = array())
    {
        // validation for constraint: array
        if ('' !== ($reportArrayErrorMessage = self::validateReportForArrayConstraintsFromSetReport($report))) {
            throw new \InvalidArgumentException($reportArrayErrorMessage, __LINE__);
        }
        $this->report = $report;
        return $this;
    }
    /**
     * Add item to report value
     * @throws \InvalidArgumentException
     * @param \StructType\Report $item
     * @return \StructType\GiroReportResponse
     */
    public function addToReport(\StructType\Report $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Report) {
            throw new \InvalidArgumentException(sprintf('The report property can only contain items of type \StructType\Report, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->report[] = $item;
        return $this;
    }
}
