<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Giro ServiceType
 * @subpackage Services
 */
class Giro extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named giroReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GiroReportRequest $giroReportRequest
     * @return \StructType\GiroReportResponse|bool
     */
    public function giroReport(\StructType\GiroReportRequest $giroReportRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->giroReport($giroReportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GiroReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
