<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reportRequest StructType
 * @subpackage Structs
 */
class ReportRequest extends AbstractStructBase
{
    /**
     * The appId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $appId;
    /**
     * The applicantName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applicantName;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $from;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $to;
    /**
     * Constructor method for reportRequest
     * @uses ReportRequest::setAppId()
     * @uses ReportRequest::setApplicantName()
     * @uses ReportRequest::setStatus()
     * @uses ReportRequest::setFrom()
     * @uses ReportRequest::setTo()
     * @param int $appId
     * @param string $applicantName
     * @param string $status
     * @param string $from
     * @param string $to
     */
    public function __construct($appId = null, $applicantName = null, $status = null, $from = null, $to = null)
    {
        $this
            ->setAppId($appId)
            ->setApplicantName($applicantName)
            ->setStatus($status)
            ->setFrom($from)
            ->setTo($to);
    }
    /**
     * Get appId value
     * @return int|null
     */
    public function getAppId()
    {
        return $this->appId;
    }
    /**
     * Set appId value
     * @param int $appId
     * @return \StructType\ReportRequest
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: int
        if (!is_null($appId) && !(is_int($appId) || ctype_digit($appId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        $this->appId = $appId;
        return $this;
    }
    /**
     * Get applicantName value
     * @return string|null
     */
    public function getApplicantName()
    {
        return $this->applicantName;
    }
    /**
     * Set applicantName value
     * @param string $applicantName
     * @return \StructType\ReportRequest
     */
    public function setApplicantName($applicantName = null)
    {
        // validation for constraint: string
        if (!is_null($applicantName) && !is_string($applicantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicantName, true), gettype($applicantName)), __LINE__);
        }
        $this->applicantName = $applicantName;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ReportRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get from value
     * @return string|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\ReportRequest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return string|null
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param string $to
     * @return \StructType\ReportRequest
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
}
