<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tokenRequest StructType
 * @subpackage Structs
 */
class TokenRequest extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $amount;
    /**
     * The constructionGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $constructionGroup;
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderId;
    /**
     * The term
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $term;
    /**
     * The contribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $contribution;
    /**
     * The shopName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shopName;
    /**
     * The shopAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shopAddress;
    /**
     * Constructor method for tokenRequest
     * @uses TokenRequest::setAmount()
     * @uses TokenRequest::setConstructionGroup()
     * @uses TokenRequest::setOrderId()
     * @uses TokenRequest::setTerm()
     * @uses TokenRequest::setContribution()
     * @uses TokenRequest::setShopName()
     * @uses TokenRequest::setShopAddress()
     * @param int $amount
     * @param int $constructionGroup
     * @param string $orderId
     * @param int $term
     * @param int $contribution
     * @param string $shopName
     * @param string $shopAddress
     */
    public function __construct($amount = null, $constructionGroup = null, $orderId = null, $term = null, $contribution = null, $shopName = null, $shopAddress = null)
    {
        $this
            ->setAmount($amount)
            ->setConstructionGroup($constructionGroup)
            ->setOrderId($orderId)
            ->setTerm($term)
            ->setContribution($contribution)
            ->setShopName($shopName)
            ->setShopAddress($shopAddress);
    }
    /**
     * Get amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param int $amount
     * @return \StructType\TokenRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get constructionGroup value
     * @return int
     */
    public function getConstructionGroup()
    {
        return $this->constructionGroup;
    }
    /**
     * Set constructionGroup value
     * @param int $constructionGroup
     * @return \StructType\TokenRequest
     */
    public function setConstructionGroup($constructionGroup = null)
    {
        // validation for constraint: int
        if (!is_null($constructionGroup) && !(is_int($constructionGroup) || ctype_digit($constructionGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($constructionGroup, true), gettype($constructionGroup)), __LINE__);
        }
        $this->constructionGroup = $constructionGroup;
        return $this;
    }
    /**
     * Get orderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param string $orderId
     * @return \StructType\TokenRequest
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get term value
     * @return int|null
     */
    public function getTerm()
    {
        return $this->term;
    }
    /**
     * Set term value
     * @param int $term
     * @return \StructType\TokenRequest
     */
    public function setTerm($term = null)
    {
        // validation for constraint: int
        if (!is_null($term) && !(is_int($term) || ctype_digit($term))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($term, true), gettype($term)), __LINE__);
        }
        $this->term = $term;
        return $this;
    }
    /**
     * Get contribution value
     * @return int|null
     */
    public function getContribution()
    {
        return $this->contribution;
    }
    /**
     * Set contribution value
     * @param int $contribution
     * @return \StructType\TokenRequest
     */
    public function setContribution($contribution = null)
    {
        // validation for constraint: int
        if (!is_null($contribution) && !(is_int($contribution) || ctype_digit($contribution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contribution, true), gettype($contribution)), __LINE__);
        }
        $this->contribution = $contribution;
        return $this;
    }
    /**
     * Get shopName value
     * @return string|null
     */
    public function getShopName()
    {
        return $this->shopName;
    }
    /**
     * Set shopName value
     * @param string $shopName
     * @return \StructType\TokenRequest
     */
    public function setShopName($shopName = null)
    {
        // validation for constraint: string
        if (!is_null($shopName) && !is_string($shopName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopName, true), gettype($shopName)), __LINE__);
        }
        $this->shopName = $shopName;
        return $this;
    }
    /**
     * Get shopAddress value
     * @return string|null
     */
    public function getShopAddress()
    {
        return $this->shopAddress;
    }
    /**
     * Set shopAddress value
     * @param string $shopAddress
     * @return \StructType\TokenRequest
     */
    public function setShopAddress($shopAddress = null)
    {
        // validation for constraint: string
        if (!is_null($shopAddress) && !is_string($shopAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopAddress, true), gettype($shopAddress)), __LINE__);
        }
        $this->shopAddress = $shopAddress;
        return $this;
    }
}
