<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for report StructType
 * @subpackage Structs
 */
class Report extends AbstractStructBase
{
    /**
     * The appId
     * @var int
     */
    public $appId;
    /**
     * The applicantName
     * @var string
     */
    public $applicantName;
    /**
     * The appBeginDate
     * @var string
     */
    public $appBeginDate;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The productDeliverable
     * @var bool
     */
    public $productDeliverable;
    /**
     * The creditAmount
     * @var int
     */
    public $creditAmount;
    /**
     * The contribution
     * @var int
     */
    public $contribution;
    /**
     * The orderId
     * @var string
     */
    public $orderId;
    /**
     * The bankAccNo
     * @var string
     */
    public $bankAccNo;
    /**
     * The contractPosNm
     * @var string
     */
    public $contractPosNm;
    /**
     * Constructor method for report
     * @uses Report::setAppId()
     * @uses Report::setApplicantName()
     * @uses Report::setAppBeginDate()
     * @uses Report::setStatus()
     * @uses Report::setProductDeliverable()
     * @uses Report::setCreditAmount()
     * @uses Report::setContribution()
     * @uses Report::setOrderId()
     * @uses Report::setBankAccNo()
     * @uses Report::setContractPosNm()
     * @param int $appId
     * @param string $applicantName
     * @param string $appBeginDate
     * @param string $status
     * @param bool $productDeliverable
     * @param int $creditAmount
     * @param int $contribution
     * @param string $orderId
     * @param string $bankAccNo
     * @param string $contractPosNm
     */
    public function __construct($appId = null, $applicantName = null, $appBeginDate = null, $status = null, $productDeliverable = null, $creditAmount = null, $contribution = null, $orderId = null, $bankAccNo = null, $contractPosNm = null)
    {
        $this
            ->setAppId($appId)
            ->setApplicantName($applicantName)
            ->setAppBeginDate($appBeginDate)
            ->setStatus($status)
            ->setProductDeliverable($productDeliverable)
            ->setCreditAmount($creditAmount)
            ->setContribution($contribution)
            ->setOrderId($orderId)
            ->setBankAccNo($bankAccNo)
            ->setContractPosNm($contractPosNm);
    }
    /**
     * Get appId value
     * @return int|null
     */
    public function getAppId()
    {
        return $this->appId;
    }
    /**
     * Set appId value
     * @param int $appId
     * @return \StructType\Report
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: int
        if (!is_null($appId) && !(is_int($appId) || ctype_digit($appId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appId, true), gettype($appId)), __LINE__);
        }
        $this->appId = $appId;
        return $this;
    }
    /**
     * Get applicantName value
     * @return string|null
     */
    public function getApplicantName()
    {
        return $this->applicantName;
    }
    /**
     * Set applicantName value
     * @param string $applicantName
     * @return \StructType\Report
     */
    public function setApplicantName($applicantName = null)
    {
        // validation for constraint: string
        if (!is_null($applicantName) && !is_string($applicantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicantName, true), gettype($applicantName)), __LINE__);
        }
        $this->applicantName = $applicantName;
        return $this;
    }
    /**
     * Get appBeginDate value
     * @return string|null
     */
    public function getAppBeginDate()
    {
        return $this->appBeginDate;
    }
    /**
     * Set appBeginDate value
     * @param string $appBeginDate
     * @return \StructType\Report
     */
    public function setAppBeginDate($appBeginDate = null)
    {
        // validation for constraint: string
        if (!is_null($appBeginDate) && !is_string($appBeginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appBeginDate, true), gettype($appBeginDate)), __LINE__);
        }
        $this->appBeginDate = $appBeginDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Report
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get productDeliverable value
     * @return bool|null
     */
    public function getProductDeliverable()
    {
        return $this->productDeliverable;
    }
    /**
     * Set productDeliverable value
     * @param bool $productDeliverable
     * @return \StructType\Report
     */
    public function setProductDeliverable($productDeliverable = null)
    {
        // validation for constraint: boolean
        if (!is_null($productDeliverable) && !is_bool($productDeliverable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($productDeliverable, true), gettype($productDeliverable)), __LINE__);
        }
        $this->productDeliverable = $productDeliverable;
        return $this;
    }
    /**
     * Get creditAmount value
     * @return int|null
     */
    public function getCreditAmount()
    {
        return $this->creditAmount;
    }
    /**
     * Set creditAmount value
     * @param int $creditAmount
     * @return \StructType\Report
     */
    public function setCreditAmount($creditAmount = null)
    {
        // validation for constraint: int
        if (!is_null($creditAmount) && !(is_int($creditAmount) || ctype_digit($creditAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditAmount, true), gettype($creditAmount)), __LINE__);
        }
        $this->creditAmount = $creditAmount;
        return $this;
    }
    /**
     * Get contribution value
     * @return int|null
     */
    public function getContribution()
    {
        return $this->contribution;
    }
    /**
     * Set contribution value
     * @param int $contribution
     * @return \StructType\Report
     */
    public function setContribution($contribution = null)
    {
        // validation for constraint: int
        if (!is_null($contribution) && !(is_int($contribution) || ctype_digit($contribution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contribution, true), gettype($contribution)), __LINE__);
        }
        $this->contribution = $contribution;
        return $this;
    }
    /**
     * Get orderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param string $orderId
     * @return \StructType\Report
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get bankAccNo value
     * @return string|null
     */
    public function getBankAccNo()
    {
        return $this->bankAccNo;
    }
    /**
     * Set bankAccNo value
     * @param string $bankAccNo
     * @return \StructType\Report
     */
    public function setBankAccNo($bankAccNo = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccNo) && !is_string($bankAccNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccNo, true), gettype($bankAccNo)), __LINE__);
        }
        $this->bankAccNo = $bankAccNo;
        return $this;
    }
    /**
     * Get contractPosNm value
     * @return string|null
     */
    public function getContractPosNm()
    {
        return $this->contractPosNm;
    }
    /**
     * Set contractPosNm value
     * @param string $contractPosNm
     * @return \StructType\Report
     */
    public function setContractPosNm($contractPosNm = null)
    {
        // validation for constraint: string
        if (!is_null($contractPosNm) && !is_string($contractPosNm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractPosNm, true), gettype($contractPosNm)), __LINE__);
        }
        $this->contractPosNm = $contractPosNm;
        return $this;
    }
}
