<?php

namespace GlsApi\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adeOption_Get StructType
 * Meta information extracted from the WSDL
 * - type: tns:adeOption_Get
 * @subpackage Structs
 */
class AdeOption_Get extends AbstractStructBase
{
    /**
     * The session
     * @var string
     */
    public $session;
    /**
     * The option
     * @var string
     */
    public $option;
    /**
     * Constructor method for adeOption_Get
     * @uses AdeOption_Get::setSession()
     * @uses AdeOption_Get::setOption()
     * @param string $session
     * @param string $option
     */
    public function __construct($session = null, $option = null)
    {
        $this
            ->setSession($session)
            ->setOption($option);
    }
    /**
     * Get session value
     * @return string|null
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param string $session
     * @return \GlsApi\StructType\AdeOption_Get
     */
    public function setSession($session = null)
    {
        // validation for constraint: string
        if (!is_null($session) && !is_string($session)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($session, true), gettype($session)), __LINE__);
        }
        $this->session = $session;
        return $this;
    }
    /**
     * Get option value
     * @return string|null
     */
    public function getOption()
    {
        return $this->option;
    }
    /**
     * Set option value
     * @param string $option
     * @return \GlsApi\StructType\AdeOption_Get
     */
    public function setOption($option = null)
    {
        // validation for constraint: string
        if (!is_null($option) && !is_string($option)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($option, true), gettype($option)), __LINE__);
        }
        $this->option = $option;
        return $this;
    }
}
