<?php

namespace GlsApi;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'cSession' => '\\GlsApi\\StructType\\CSession',
            'cConsign' => '\\GlsApi\\StructType\\CConsign',
            'cSenderAddress' => '\\GlsApi\\StructType\\CSenderAddress',
            'cServicesBool' => '\\GlsApi\\StructType\\CServicesBool',
            'cServiceDAW' => '\\GlsApi\\StructType\\CServiceDAW',
            'cServiceIDENT' => '\\GlsApi\\StructType\\CServiceIDENT',
            'cServicePPE' => '\\GlsApi\\StructType\\CServicePPE',
            'cServiceSDS' => '\\GlsApi\\StructType\\CServiceSDS',
            'cParcelsArray' => '\\GlsApi\\ArrayType\\CParcelsArray',
            'cParcel' => '\\GlsApi\\StructType\\CParcel',
            'cID' => '\\GlsApi\\StructType\\CID',
            'cConsignExt' => '\\GlsApi\\StructType\\CConsignExt',
            'cCustomsDeclaration' => '\\GlsApi\\StructType\\CCustomsDeclaration',
            'cCustomsAttachedFilesArray' => '\\GlsApi\\ArrayType\\CCustomsAttachedFilesArray',
            'cCustomsAttachedFile' => '\\GlsApi\\StructType\\CCustomsAttachedFile',
            'cCustomsArticlesArray' => '\\GlsApi\\ArrayType\\CCustomsArticlesArray',
            'cCustomsArticle' => '\\GlsApi\\StructType\\CCustomsArticle',
            'cConsignsIDsArray' => '\\GlsApi\\ArrayType\\CConsignsIDsArray',
            'cLabels' => '\\GlsApi\\StructType\\CLabels',
            'cLabelsArray' => '\\GlsApi\\ArrayType\\CLabelsArray',
            'cLabel' => '\\GlsApi\\StructType\\CLabel',
            'cLabelsIdent' => '\\GlsApi\\StructType\\CLabelsIdent',
            'cPickupsIDsArray' => '\\GlsApi\\ArrayType\\CPickupsIDsArray',
            'cPickup' => '\\GlsApi\\StructType\\CPickup',
            'cConsignBindIDsArray' => '\\GlsApi\\ArrayType\\CConsignBindIDsArray',
            'cConsignBindIDs' => '\\GlsApi\\StructType\\CConsignBindIDs',
            'cReceipt' => '\\GlsApi\\StructType\\CReceipt',
            'cIdent' => '\\GlsApi\\StructType\\CIdent',
            'cStringArray' => '\\GlsApi\\ArrayType\\CStringArray',
            'cPartnerParcelNumber' => '\\GlsApi\\StructType\\CPartnerParcelNumber',
            'cProfilesArray' => '\\GlsApi\\ArrayType\\CProfilesArray',
            'cProfile' => '\\GlsApi\\StructType\\CProfile',
            'cLang' => '\\GlsApi\\StructType\\CLang',
            'cStatus' => '\\GlsApi\\StructType\\CStatus',
            'cSenderAddressArray' => '\\GlsApi\\ArrayType\\CSenderAddressArray',
            'cServices' => '\\GlsApi\\StructType\\CServices',
            'cCODMax' => '\\GlsApi\\StructType\\CCODMax',
            'cParcelWeightsMax' => '\\GlsApi\\StructType\\CParcelWeightsMax',
            'cCity' => '\\GlsApi\\StructType\\CCity',
            'cBooleanValue' => '\\GlsApi\\StructType\\CBooleanValue',
            'cValue' => '\\GlsApi\\StructType\\CValue',
            'cParcelShopArray' => '\\GlsApi\\ArrayType\\CParcelShopArray',
            'cParcelShop' => '\\GlsApi\\StructType\\CParcelShop',
            'cParcelShop2Array' => '\\GlsApi\\ArrayType\\CParcelShop2Array',
            'cParcelShop2' => '\\GlsApi\\StructType\\CParcelShop2',
            'cParcelShop2OpeningHoursArray' => '\\GlsApi\\ArrayType\\CParcelShop2OpeningHoursArray',
            'cParcelShop2OpeningHours' => '\\GlsApi\\StructType\\CParcelShop2OpeningHours',
            'cParcelShop2HolidaysArray' => '\\GlsApi\\ArrayType\\CParcelShop2HolidaysArray',
            'cParcelShop2Holidays' => '\\GlsApi\\StructType\\CParcelShop2Holidays',
            'cParcelShop2PaymentsArray' => '\\GlsApi\\ArrayType\\CParcelShop2PaymentsArray',
            'cParcelShop2Payment' => '\\GlsApi\\StructType\\CParcelShop2Payment',
            'cParcelShop2GroupsArray' => '\\GlsApi\\ArrayType\\CParcelShop2GroupsArray',
            'cParcelShop2Group' => '\\GlsApi\\StructType\\CParcelShop2Group',
            'cParcelShop2ServicesArray' => '\\GlsApi\\ArrayType\\CParcelShop2ServicesArray',
            'cParcelShop2Service' => '\\GlsApi\\StructType\\CParcelShop2Service',
            'cParcelShop2ValidsArray' => '\\GlsApi\\ArrayType\\CParcelShop2ValidsArray',
            'cParcelShop2Valid' => '\\GlsApi\\StructType\\CParcelShop2Valid',
            'cParcelShop2DescArray' => '\\GlsApi\\ArrayType\\CParcelShop2DescArray',
            'cParcelShop2Desc' => '\\GlsApi\\StructType\\CParcelShop2Desc',
            'cParcelShop2InfoArray' => '\\GlsApi\\ArrayType\\CParcelShop2InfoArray',
            'cParcelShop2Info' => '\\GlsApi\\StructType\\CParcelShop2Info',
            'cCustomsDecPdf' => '\\GlsApi\\StructType\\CCustomsDecPdf',
            'cPODsArray' => '\\GlsApi\\ArrayType\\CPODsArray',
            'cPOD' => '\\GlsApi\\StructType\\CPOD',
            'cPodPdf' => '\\GlsApi\\StructType\\CPodPdf',
            'adeLogin' => '\\GlsApi\\StructType\\AdeLogin',
            'adeLoginResponse' => '\\GlsApi\\StructType\\AdeLoginResponse',
            'adeLoginIntegrator' => '\\GlsApi\\StructType\\AdeLoginIntegrator',
            'adeLoginIntegratorResponse' => '\\GlsApi\\StructType\\AdeLoginIntegratorResponse',
            'adeLogout' => '\\GlsApi\\StructType\\AdeLogout',
            'adeLogoutResponse' => '\\GlsApi\\StructType\\AdeLogoutResponse',
            'adePreparingBox_Insert' => '\\GlsApi\\StructType\\AdePreparingBox_Insert',
            'adePreparingBox_InsertResponse' => '\\GlsApi\\StructType\\AdePreparingBox_InsertResponse',
            'adePreparingBox_InsertExt' => '\\GlsApi\\StructType\\AdePreparingBox_InsertExt',
            'adePreparingBox_InsertExtResponse' => '\\GlsApi\\StructType\\AdePreparingBox_InsertExtResponse',
            'adePreparingBox_GetConsignIDs' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignIDs',
            'adePreparingBox_GetConsignIDsResponse' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignIDsResponse',
            'adePreparingBox_DeleteConsign' => '\\GlsApi\\StructType\\AdePreparingBox_DeleteConsign',
            'adePreparingBox_DeleteConsignResponse' => '\\GlsApi\\StructType\\AdePreparingBox_DeleteConsignResponse',
            'adePreparingBox_GetConsign' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsign',
            'adePreparingBox_GetConsignResponse' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignResponse',
            'adePreparingBox_GetConsignLabels' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignLabels',
            'adePreparingBox_GetConsignLabelsResponse' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignLabelsResponse',
            'adePreparingBox_GetConsignLabelsExt' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignLabelsExt',
            'adePreparingBox_GetConsignLabelsExtResponse' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignLabelsExtResponse',
            'adePreparingBox_GetConsignDocs' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignDocs',
            'adePreparingBox_GetConsignDocsResponse' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignDocsResponse',
            'adePreparingBox_GetConsignsLabels' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignsLabels',
            'adePreparingBox_GetConsignsLabelsResponse' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignsLabelsResponse',
            'adePreparingBox_GetParcelLabel' => '\\GlsApi\\StructType\\AdePreparingBox_GetParcelLabel',
            'adePreparingBox_GetParcelLabelResponse' => '\\GlsApi\\StructType\\AdePreparingBox_GetParcelLabelResponse',
            'adePickup_Create' => '\\GlsApi\\StructType\\AdePickup_Create',
            'adePickup_CreateResponse' => '\\GlsApi\\StructType\\AdePickup_CreateResponse',
            'adePickup_GetIDs' => '\\GlsApi\\StructType\\AdePickup_GetIDs',
            'adePickup_GetIDsResponse' => '\\GlsApi\\StructType\\AdePickup_GetIDsResponse',
            'adePickup_Get' => '\\GlsApi\\StructType\\AdePickup_Get',
            'adePickup_GetResponse' => '\\GlsApi\\StructType\\AdePickup_GetResponse',
            'adePickup_GetConsignBinds' => '\\GlsApi\\StructType\\AdePickup_GetConsignBinds',
            'adePickup_GetConsignBindsResponse' => '\\GlsApi\\StructType\\AdePickup_GetConsignBindsResponse',
            'adePickup_GetConsignIDs' => '\\GlsApi\\StructType\\AdePickup_GetConsignIDs',
            'adePickup_GetConsignIDsResponse' => '\\GlsApi\\StructType\\AdePickup_GetConsignIDsResponse',
            'adePickup_GetConsign' => '\\GlsApi\\StructType\\AdePickup_GetConsign',
            'adePickup_GetConsignResponse' => '\\GlsApi\\StructType\\AdePickup_GetConsignResponse',
            'adePickup_GetReceipt' => '\\GlsApi\\StructType\\AdePickup_GetReceipt',
            'adePickup_GetReceiptResponse' => '\\GlsApi\\StructType\\AdePickup_GetReceiptResponse',
            'adePickup_GetLabels' => '\\GlsApi\\StructType\\AdePickup_GetLabels',
            'adePickup_GetLabelsResponse' => '\\GlsApi\\StructType\\AdePickup_GetLabelsResponse',
            'adePickup_GetIdent' => '\\GlsApi\\StructType\\AdePickup_GetIdent',
            'adePickup_GetIdentResponse' => '\\GlsApi\\StructType\\AdePickup_GetIdentResponse',
            'adePickup_GetConsignLabels' => '\\GlsApi\\StructType\\AdePickup_GetConsignLabels',
            'adePickup_GetConsignLabelsResponse' => '\\GlsApi\\StructType\\AdePickup_GetConsignLabelsResponse',
            'adePickup_GetConsignLabelsExt' => '\\GlsApi\\StructType\\AdePickup_GetConsignLabelsExt',
            'adePickup_GetConsignLabelsExtResponse' => '\\GlsApi\\StructType\\AdePickup_GetConsignLabelsExtResponse',
            'adePickup_GetParcelLabel' => '\\GlsApi\\StructType\\AdePickup_GetParcelLabel',
            'adePickup_GetParcelLabelResponse' => '\\GlsApi\\StructType\\AdePickup_GetParcelLabelResponse',
            'adePickup_GetParcelsLabels' => '\\GlsApi\\StructType\\AdePickup_GetParcelsLabels',
            'adePickup_GetParcelsLabelsResponse' => '\\GlsApi\\StructType\\AdePickup_GetParcelsLabelsResponse',
            'adePickup_ParcelNumberSearch' => '\\GlsApi\\StructType\\AdePickup_ParcelNumberSearch',
            'adePickup_ParcelNumberSearchResponse' => '\\GlsApi\\StructType\\AdePickup_ParcelNumberSearchResponse',
            'adePartner_GetParcelNumber' => '\\GlsApi\\StructType\\AdePartner_GetParcelNumber',
            'adePartner_GetParcelNumberResponse' => '\\GlsApi\\StructType\\AdePartner_GetParcelNumberResponse',
            'adeProfile_GetIDs' => '\\GlsApi\\StructType\\AdeProfile_GetIDs',
            'adeProfile_GetIDsResponse' => '\\GlsApi\\StructType\\AdeProfile_GetIDsResponse',
            'adeProfile_GetActive' => '\\GlsApi\\StructType\\AdeProfile_GetActive',
            'adeProfile_GetActiveResponse' => '\\GlsApi\\StructType\\AdeProfile_GetActiveResponse',
            'adeProfile_Change' => '\\GlsApi\\StructType\\AdeProfile_Change',
            'adeProfile_ChangeResponse' => '\\GlsApi\\StructType\\AdeProfile_ChangeResponse',
            'adeLang_GetActive' => '\\GlsApi\\StructType\\AdeLang_GetActive',
            'adeLang_GetActiveResponse' => '\\GlsApi\\StructType\\AdeLang_GetActiveResponse',
            'adeLang_Change' => '\\GlsApi\\StructType\\AdeLang_Change',
            'adeLang_ChangeResponse' => '\\GlsApi\\StructType\\AdeLang_ChangeResponse',
            'adePfc_GetStatus' => '\\GlsApi\\StructType\\AdePfc_GetStatus',
            'adePfc_GetStatusResponse' => '\\GlsApi\\StructType\\AdePfc_GetStatusResponse',
            'adePfc_GetDictionary' => '\\GlsApi\\StructType\\AdePfc_GetDictionary',
            'adePfc_GetDictionaryResponse' => '\\GlsApi\\StructType\\AdePfc_GetDictionaryResponse',
            'adeSendAddr_GetStatus' => '\\GlsApi\\StructType\\AdeSendAddr_GetStatus',
            'adeSendAddr_GetStatusResponse' => '\\GlsApi\\StructType\\AdeSendAddr_GetStatusResponse',
            'adeSendAddr_GetDictionary' => '\\GlsApi\\StructType\\AdeSendAddr_GetDictionary',
            'adeSendAddr_GetDictionaryResponse' => '\\GlsApi\\StructType\\AdeSendAddr_GetDictionaryResponse',
            'adeServices_GetAllowed' => '\\GlsApi\\StructType\\AdeServices_GetAllowed',
            'adeServices_GetAllowedResponse' => '\\GlsApi\\StructType\\AdeServices_GetAllowedResponse',
            'adeServices_GetMaxCOD' => '\\GlsApi\\StructType\\AdeServices_GetMaxCOD',
            'adeServices_GetMaxCODResponse' => '\\GlsApi\\StructType\\AdeServices_GetMaxCODResponse',
            'adeServices_GetMaxParcelWeights' => '\\GlsApi\\StructType\\AdeServices_GetMaxParcelWeights',
            'adeServices_GetMaxParcelWeightsResponse' => '\\GlsApi\\StructType\\AdeServices_GetMaxParcelWeightsResponse',
            'adeServices_GetGuaranteed' => '\\GlsApi\\StructType\\AdeServices_GetGuaranteed',
            'adeServices_GetGuaranteedResponse' => '\\GlsApi\\StructType\\AdeServices_GetGuaranteedResponse',
            'adeServices_GetCountriesSDS' => '\\GlsApi\\StructType\\AdeServices_GetCountriesSDS',
            'adeServices_GetCountriesSDSResponse' => '\\GlsApi\\StructType\\AdeServices_GetCountriesSDSResponse',
            'adeServices_GetCountriesSRS' => '\\GlsApi\\StructType\\AdeServices_GetCountriesSRS',
            'adeServices_GetCountriesSRSResponse' => '\\GlsApi\\StructType\\AdeServices_GetCountriesSRSResponse',
            'adeZip_GetCity' => '\\GlsApi\\StructType\\AdeZip_GetCity',
            'adeZip_GetCityResponse' => '\\GlsApi\\StructType\\AdeZip_GetCityResponse',
            'adeZip_CustomsRequired' => '\\GlsApi\\StructType\\AdeZip_CustomsRequired',
            'adeZip_CustomsRequiredResponse' => '\\GlsApi\\StructType\\AdeZip_CustomsRequiredResponse',
            'adeOption_Get' => '\\GlsApi\\StructType\\AdeOption_Get',
            'adeOption_GetResponse' => '\\GlsApi\\StructType\\AdeOption_GetResponse',
            'adeOption_Set' => '\\GlsApi\\StructType\\AdeOption_Set',
            'adeOption_SetResponse' => '\\GlsApi\\StructType\\AdeOption_SetResponse',
            'adeParcelShop_SearchByZip' => '\\GlsApi\\StructType\\AdeParcelShop_SearchByZip',
            'adeParcelShop_SearchByZipResponse' => '\\GlsApi\\StructType\\AdeParcelShop_SearchByZipResponse',
            'adeParcelShop_SearchByID' => '\\GlsApi\\StructType\\AdeParcelShop_SearchByID',
            'adeParcelShop_SearchByIDResponse' => '\\GlsApi\\StructType\\AdeParcelShop_SearchByIDResponse',
            'adeParcelShop_GetByCountry' => '\\GlsApi\\StructType\\AdeParcelShop_GetByCountry',
            'adeParcelShop_GetByCountryResponse' => '\\GlsApi\\StructType\\AdeParcelShop_GetByCountryResponse',
            'adeParcelShop2_GetByCountry' => '\\GlsApi\\StructType\\AdeParcelShop2_GetByCountry',
            'adeParcelShop2_GetByCountryResponse' => '\\GlsApi\\StructType\\AdeParcelShop2_GetByCountryResponse',
            'adeParcelShop2_SearchByZip' => '\\GlsApi\\StructType\\AdeParcelShop2_SearchByZip',
            'adeParcelShop2_SearchByZipResponse' => '\\GlsApi\\StructType\\AdeParcelShop2_SearchByZipResponse',
            'adePreparingBox_GetConsignCustomsDec' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignCustomsDec',
            'adePreparingBox_GetConsignCustomsDecResponse' => '\\GlsApi\\StructType\\AdePreparingBox_GetConsignCustomsDecResponse',
            'adePickup_GetConsignCustomsDec' => '\\GlsApi\\StructType\\AdePickup_GetConsignCustomsDec',
            'adePickup_GetConsignCustomsDecResponse' => '\\GlsApi\\StructType\\AdePickup_GetConsignCustomsDecResponse',
            'adePickup_GetConsignPODs' => '\\GlsApi\\StructType\\AdePickup_GetConsignPODs',
            'adePickup_GetConsignPODsResponse' => '\\GlsApi\\StructType\\AdePickup_GetConsignPODsResponse',
            'adePOD_Get' => '\\GlsApi\\StructType\\AdePOD_Get',
            'adePOD_GetResponse' => '\\GlsApi\\StructType\\AdePOD_GetResponse',
            'adeCourier_Order' => '\\GlsApi\\StructType\\AdeCourier_Order',
            'adeCourier_OrderResponse' => '\\GlsApi\\StructType\\AdeCourier_OrderResponse',
        );
    }
}
