<?php

namespace GlsApi\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for cParcelShop2ServicesArray ArrayType
 * @subpackage Arrays
 */
class CParcelShop2ServicesArray extends AbstractStructArrayBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \GlsApi\StructType\CParcelShop2Service[]
     */
    public $items;
    /**
     * Constructor method for cParcelShop2ServicesArray
     * @uses CParcelShop2ServicesArray::setItems()
     * @param \GlsApi\StructType\CParcelShop2Service[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return \GlsApi\StructType\CParcelShop2Service[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cParcelShop2ServicesArrayItemsItem) {
            // validation for constraint: itemType
            if (!$cParcelShop2ServicesArrayItemsItem instanceof \GlsApi\StructType\CParcelShop2Service) {
                $invalidValues[] = is_object($cParcelShop2ServicesArrayItemsItem) ? get_class($cParcelShop2ServicesArrayItemsItem) : sprintf('%s(%s)', gettype($cParcelShop2ServicesArrayItemsItem), var_export($cParcelShop2ServicesArrayItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \GlsApi\StructType\CParcelShop2Service, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \GlsApi\StructType\CParcelShop2Service[] $items
     * @return \GlsApi\ArrayType\CParcelShop2ServicesArray
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \GlsApi\StructType\CParcelShop2Service $item
     * @return \GlsApi\ArrayType\CParcelShop2ServicesArray
     */
    public function addToItems(\GlsApi\StructType\CParcelShop2Service $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GlsApi\StructType\CParcelShop2Service) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \GlsApi\StructType\CParcelShop2Service, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \GlsApi\StructType\CParcelShop2Service
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \GlsApi\StructType\CParcelShop2Service
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \GlsApi\StructType\CParcelShop2Service
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \GlsApi\StructType\CParcelShop2Service
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \GlsApi\StructType\CParcelShop2Service
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string items
     */
    public function getAttributeName()
    {
        return 'items';
    }
}
