<?php

namespace GlsApi\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for cConsignsIDsArray ArrayType
 * @subpackage Arrays
 */
class CConsignsIDsArray extends AbstractStructArrayBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var int[]
     */
    public $items;
    /**
     * Constructor method for cConsignsIDsArray
     * @uses CConsignsIDsArray::setItems()
     * @param int[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return int[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cConsignsIDsArrayItemsItem) {
            // validation for constraint: itemType
            if (!(is_int($cConsignsIDsArrayItemsItem) || ctype_digit($cConsignsIDsArrayItemsItem))) {
                $invalidValues[] = is_object($cConsignsIDsArrayItemsItem) ? get_class($cConsignsIDsArrayItemsItem) : sprintf('%s(%s)', gettype($cConsignsIDsArrayItemsItem), var_export($cConsignsIDsArrayItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param int[] $items
     * @return \GlsApi\ArrayType\CConsignsIDsArray
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \GlsApi\ArrayType\CConsignsIDsArray
     */
    public function addToItems($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string items
     */
    public function getAttributeName()
    {
        return 'items';
    }
}
