<?php

namespace GlsApi\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cLabelsIdent StructType
 * @subpackage Structs
 */
class CLabelsIdent extends AbstractStructBase
{
    /**
     * The labels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $labels;
    /**
     * The ident
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ident;
    /**
     * Constructor method for cLabelsIdent
     * @uses CLabelsIdent::setLabels()
     * @uses CLabelsIdent::setIdent()
     * @param string $labels
     * @param string $ident
     */
    public function __construct($labels = null, $ident = null)
    {
        $this
            ->setLabels($labels)
            ->setIdent($ident);
    }
    /**
     * Get labels value
     * @return string
     */
    public function getLabels()
    {
        return $this->labels;
    }
    /**
     * Set labels value
     * @param string $labels
     * @return \GlsApi\StructType\CLabelsIdent
     */
    public function setLabels($labels = null)
    {
        // validation for constraint: string
        if (!is_null($labels) && !is_string($labels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labels, true), gettype($labels)), __LINE__);
        }
        $this->labels = $labels;
        return $this;
    }
    /**
     * Get ident value
     * @return string
     */
    public function getIdent()
    {
        return $this->ident;
    }
    /**
     * Set ident value
     * @param string $ident
     * @return \GlsApi\StructType\CLabelsIdent
     */
    public function setIdent($ident = null)
    {
        // validation for constraint: string
        if (!is_null($ident) && !is_string($ident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ident, true), gettype($ident)), __LINE__);
        }
        $this->ident = $ident;
        return $this;
    }
}
