<?php

namespace GlsApi\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cLabel StructType
 * @subpackage Structs
 */
class CLabel extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $number;
    /**
     * The file
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $file;
    /**
     * Constructor method for cLabel
     * @uses CLabel::setNumber()
     * @uses CLabel::setFile()
     * @param string $number
     * @param string $file
     */
    public function __construct($number = null, $file = null)
    {
        $this
            ->setNumber($number)
            ->setFile($file);
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \GlsApi\StructType\CLabel
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get file value
     * @return string
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param string $file
     * @return \GlsApi\StructType\CLabel
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file, true), gettype($file)), __LINE__);
        }
        $this->file = $file;
        return $this;
    }
}
