<?php

namespace GlsApi\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ade ServiceType
 * @subpackage Services
 */
class Ade extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeLogin
     * Meta information extracted from the WSDL
     * - documentation: Login to ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeLogin $parameters
     * @return \GlsApi\StructType\AdeLoginResponse|bool
     */
    public function adeLogin(\GlsApi\StructType\AdeLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLoginIntegrator
     * Meta information extracted from the WSDL
     * - documentation: Login integrator to ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeLoginIntegrator $parameters
     * @return \GlsApi\StructType\AdeLoginIntegratorResponse|bool
     */
    public function adeLoginIntegrator(\GlsApi\StructType\AdeLoginIntegrator $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLoginIntegrator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLogout
     * Meta information extracted from the WSDL
     * - documentation: Logout from ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeLogout $parameters
     * @return \GlsApi\StructType\AdeLogoutResponse|bool
     */
    public function adeLogout(\GlsApi\StructType\AdeLogout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLogout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_Insert
     * Meta information extracted from the WSDL
     * - documentation: Insert consignment to preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_Insert $parameters
     * @return \GlsApi\StructType\AdePreparingBox_InsertResponse|bool
     */
    public function adePreparingBox_Insert(\GlsApi\StructType\AdePreparingBox_Insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_Insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_InsertExt
     * Meta information extracted from the WSDL
     * - documentation: Insert consignment to preparing box (version with Customs Declaration).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_InsertExt $parameters
     * @return \GlsApi\StructType\AdePreparingBox_InsertExtResponse|bool
     */
    public function adePreparingBox_InsertExt(\GlsApi\StructType\AdePreparingBox_InsertExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_InsertExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignIDs
     * Meta information extracted from the WSDL
     * - documentation: List consignments from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_GetConsignIDs $parameters
     * @return \GlsApi\StructType\AdePreparingBox_GetConsignIDsResponse|bool
     */
    public function adePreparingBox_GetConsignIDs(\GlsApi\StructType\AdePreparingBox_GetConsignIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_DeleteConsign
     * Meta information extracted from the WSDL
     * - documentation: Delete consignment from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_DeleteConsign $parameters
     * @return \GlsApi\StructType\AdePreparingBox_DeleteConsignResponse|bool
     */
    public function adePreparingBox_DeleteConsign(\GlsApi\StructType\AdePreparingBox_DeleteConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_DeleteConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsign
     * Meta information extracted from the WSDL
     * - documentation: Get data about consignment from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_GetConsign $parameters
     * @return \GlsApi\StructType\AdePreparingBox_GetConsignResponse|bool
     */
    public function adePreparingBox_GetConsign(\GlsApi\StructType\AdePreparingBox_GetConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignLabels
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_GetConsignLabels $parameters
     * @return \GlsApi\StructType\AdePreparingBox_GetConsignLabelsResponse|bool
     */
    public function adePreparingBox_GetConsignLabels(\GlsApi\StructType\AdePreparingBox_GetConsignLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * adePreparingBox_GetConsignLabelsExt
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_GetConsignLabelsExt $parameters
     * @return \GlsApi\StructType\AdePreparingBox_GetConsignLabelsExtResponse|bool
     */
    public function adePreparingBox_GetConsignLabelsExt(\GlsApi\StructType\AdePreparingBox_GetConsignLabelsExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignLabelsExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignDocs
     * Meta information extracted from the WSDL
     * - documentation: Get all consignment documents from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_GetConsignDocs $parameters
     * @return \GlsApi\StructType\AdePreparingBox_GetConsignDocsResponse|bool
     */
    public function adePreparingBox_GetConsignDocs(\GlsApi\StructType\AdePreparingBox_GetConsignDocs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignDocs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignsLabels
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box (via consign ids array)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_GetConsignsLabels $parameters
     * @return \GlsApi\StructType\AdePreparingBox_GetConsignsLabelsResponse|bool
     */
    public function adePreparingBox_GetConsignsLabels(\GlsApi\StructType\AdePreparingBox_GetConsignsLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignsLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Get parcel label from preparing box
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_GetParcelLabel $parameters
     * @return \GlsApi\StructType\AdePreparingBox_GetParcelLabelResponse|bool
     */
    public function adePreparingBox_GetParcelLabel(\GlsApi\StructType\AdePreparingBox_GetParcelLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetParcelLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_Create
     * Meta information extracted from the WSDL
     * - documentation: Create pickup from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_Create $parameters
     * @return \GlsApi\StructType\AdePickup_CreateResponse|bool
     */
    public function adePickup_Create(\GlsApi\StructType\AdePickup_Create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_Create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetIDs
     * Meta information extracted from the WSDL
     * - documentation: List avail pickups.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetIDs $parameters
     * @return \GlsApi\StructType\AdePickup_GetIDsResponse|bool
     */
    public function adePickup_GetIDs(\GlsApi\StructType\AdePickup_GetIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_Get
     * Meta information extracted from the WSDL
     * - documentation: Get info about pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_Get $parameters
     * @return \GlsApi\StructType\AdePickup_GetResponse|bool
     */
    public function adePickup_Get(\GlsApi\StructType\AdePickup_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignBinds
     * Meta information extracted from the WSDL
     * - documentation: List of shipment IDs with their associated/bind shipment IDs from preparing box for a single shipment confirmation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetConsignBinds $parameters
     * @return \GlsApi\StructType\AdePickup_GetConsignBindsResponse|bool
     */
    public function adePickup_GetConsignBinds(\GlsApi\StructType\AdePickup_GetConsignBinds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignBinds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignIDs
     * Meta information extracted from the WSDL
     * - documentation: List consignments from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetConsignIDs $parameters
     * @return \GlsApi\StructType\AdePickup_GetConsignIDsResponse|bool
     */
    public function adePickup_GetConsignIDs(\GlsApi\StructType\AdePickup_GetConsignIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsign
     * Meta information extracted from the WSDL
     * - documentation: Get data about consignment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetConsign $parameters
     * @return \GlsApi\StructType\AdePickup_GetConsignResponse|bool
     */
    public function adePickup_GetConsign(\GlsApi\StructType\AdePickup_GetConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetReceipt
     * Meta information extracted from the WSDL
     * - documentation: Get receipt from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetReceipt $parameters
     * @return \GlsApi\StructType\AdePickup_GetReceiptResponse|bool
     */
    public function adePickup_GetReceipt(\GlsApi\StructType\AdePickup_GetReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetLabels
     * Meta information extracted from the WSDL
     * - documentation: Get labels from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetLabels $parameters
     * @return \GlsApi\StructType\AdePickup_GetLabelsResponse|bool
     */
    public function adePickup_GetLabels(\GlsApi\StructType\AdePickup_GetLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetIdent
     * Meta information extracted from the WSDL
     * - documentation: Get ident document from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetIdent $parameters
     * @return \GlsApi\StructType\AdePickup_GetIdentResponse|bool
     */
    public function adePickup_GetIdent(\GlsApi\StructType\AdePickup_GetIdent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetIdent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignLabels
     * Meta information extracted from the WSDL
     * - documentation: Get labels from consignment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetConsignLabels $parameters
     * @return \GlsApi\StructType\AdePickup_GetConsignLabelsResponse|bool
     */
    public function adePickup_GetConsignLabels(\GlsApi\StructType\AdePickup_GetConsignLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignLabelsExt
     * Meta information extracted from the WSDL
     * - documentation: Get labels from consignment (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetConsignLabelsExt $parameters
     * @return \GlsApi\StructType\AdePickup_GetConsignLabelsExtResponse|bool
     */
    public function adePickup_GetConsignLabelsExt(\GlsApi\StructType\AdePickup_GetConsignLabelsExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignLabelsExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Get parcel label from pickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetParcelLabel $parameters
     * @return \GlsApi\StructType\AdePickup_GetParcelLabelResponse|bool
     */
    public function adePickup_GetParcelLabel(\GlsApi\StructType\AdePickup_GetParcelLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetParcelLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetParcelsLabels
     * Meta information extracted from the WSDL
     * - documentation: Get parcels labels from pickup (array nums on input)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetParcelsLabels $parameters
     * @return \GlsApi\StructType\AdePickup_GetParcelsLabelsResponse|bool
     */
    public function adePickup_GetParcelsLabels(\GlsApi\StructType\AdePickup_GetParcelsLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetParcelsLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_ParcelNumberSearch
     * Meta information extracted from the WSDL
     * - documentation: Search for consignment based on number of parcel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_ParcelNumberSearch $parameters
     * @return \GlsApi\StructType\AdePickup_ParcelNumberSearchResponse|bool
     */
    public function adePickup_ParcelNumberSearch(\GlsApi\StructType\AdePickup_ParcelNumberSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_ParcelNumberSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePartner_GetParcelNumber
     * Meta information extracted from the WSDL
     * - documentation: Search for partner parcel number based on GLS parcel number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePartner_GetParcelNumber $parameters
     * @return \GlsApi\StructType\AdePartner_GetParcelNumberResponse|bool
     */
    public function adePartner_GetParcelNumber(\GlsApi\StructType\AdePartner_GetParcelNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePartner_GetParcelNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_GetIDs
     * Meta information extracted from the WSDL
     * - documentation: Get profiles info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeProfile_GetIDs $parameters
     * @return \GlsApi\StructType\AdeProfile_GetIDsResponse|bool
     */
    public function adeProfile_GetIDs(\GlsApi\StructType\AdeProfile_GetIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_GetIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_GetActive
     * Meta information extracted from the WSDL
     * - documentation: Get active profile info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeProfile_GetActive $parameters
     * @return \GlsApi\StructType\AdeProfile_GetActiveResponse|bool
     */
    public function adeProfile_GetActive(\GlsApi\StructType\AdeProfile_GetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_GetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_Change
     * Meta information extracted from the WSDL
     * - documentation: Change profile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeProfile_Change $parameters
     * @return \GlsApi\StructType\AdeProfile_ChangeResponse|bool
     */
    public function adeProfile_Change(\GlsApi\StructType\AdeProfile_Change $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_Change($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLang_GetActive
     * Meta information extracted from the WSDL
     * - documentation: Get active language.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeLang_GetActive $parameters
     * @return \GlsApi\StructType\AdeLang_GetActiveResponse|bool
     */
    public function adeLang_GetActive(\GlsApi\StructType\AdeLang_GetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLang_GetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLang_Change
     * Meta information extracted from the WSDL
     * - documentation: Change language
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeLang_Change $parameters
     * @return \GlsApi\StructType\AdeLang_ChangeResponse|bool
     */
    public function adeLang_Change(\GlsApi\StructType\AdeLang_Change $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLang_Change($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePfc_GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Return the PFC status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePfc_GetStatus $parameters
     * @return \GlsApi\StructType\AdePfc_GetStatusResponse|bool
     */
    public function adePfc_GetStatus(\GlsApi\StructType\AdePfc_GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePfc_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePfc_GetDictionary
     * Meta information extracted from the WSDL
     * - documentation: Return the addresss of the sender dictionary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePfc_GetDictionary $parameters
     * @return \GlsApi\StructType\AdePfc_GetDictionaryResponse|bool
     */
    public function adePfc_GetDictionary(\GlsApi\StructType\AdePfc_GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePfc_GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeSendAddr_GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Return the PFC status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeSendAddr_GetStatus $parameters
     * @return \GlsApi\StructType\AdeSendAddr_GetStatusResponse|bool
     */
    public function adeSendAddr_GetStatus(\GlsApi\StructType\AdeSendAddr_GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeSendAddr_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeSendAddr_GetDictionary
     * Meta information extracted from the WSDL
     * - documentation: Return the addresss of the sender dictionary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeSendAddr_GetDictionary $parameters
     * @return \GlsApi\StructType\AdeSendAddr_GetDictionaryResponse|bool
     */
    public function adeSendAddr_GetDictionary(\GlsApi\StructType\AdeSendAddr_GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeSendAddr_GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetAllowed
     * Meta information extracted from the WSDL
     * - documentation: Get allowed services for user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeServices_GetAllowed $parameters
     * @return \GlsApi\StructType\AdeServices_GetAllowedResponse|bool
     */
    public function adeServices_GetAllowed(\GlsApi\StructType\AdeServices_GetAllowed $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetAllowed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetMaxCOD
     * Meta information extracted from the WSDL
     * - documentation: Return maximum amount of COD.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeServices_GetMaxCOD $parameters
     * @return \GlsApi\StructType\AdeServices_GetMaxCODResponse|bool
     */
    public function adeServices_GetMaxCOD(\GlsApi\StructType\AdeServices_GetMaxCOD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetMaxCOD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetMaxParcelWeights
     * Meta information extracted from the WSDL
     * - documentation: Return maximum parcel weights (national and international).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeServices_GetMaxParcelWeights $parameters
     * @return \GlsApi\StructType\AdeServices_GetMaxParcelWeightsResponse|bool
     */
    public function adeServices_GetMaxParcelWeights(\GlsApi\StructType\AdeServices_GetMaxParcelWeights $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetMaxParcelWeights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetGuaranteed
     * Meta information extracted from the WSDL
     * - documentation: Get guaranteed services for given zip code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeServices_GetGuaranteed $parameters
     * @return \GlsApi\StructType\AdeServices_GetGuaranteedResponse|bool
     */
    public function adeServices_GetGuaranteed(\GlsApi\StructType\AdeServices_GetGuaranteed $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetGuaranteed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetCountriesSDS
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries supporting SDS service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeServices_GetCountriesSDS $parameters
     * @return \GlsApi\StructType\AdeServices_GetCountriesSDSResponse|bool
     */
    public function adeServices_GetCountriesSDS(\GlsApi\StructType\AdeServices_GetCountriesSDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesSDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetCountriesSRS
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries supporting SRS service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeServices_GetCountriesSRS $parameters
     * @return \GlsApi\StructType\AdeServices_GetCountriesSRSResponse|bool
     */
    public function adeServices_GetCountriesSRS(\GlsApi\StructType\AdeServices_GetCountriesSRS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesSRS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeZip_GetCity
     * Meta information extracted from the WSDL
     * - documentation: Search for city.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeZip_GetCity $parameters
     * @return \GlsApi\StructType\AdeZip_GetCityResponse|bool
     */
    public function adeZip_GetCity(\GlsApi\StructType\AdeZip_GetCity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeZip_GetCity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeZip_CustomsRequired
     * Meta information extracted from the WSDL
     * - documentation: Search for custom declaration requirements.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeZip_CustomsRequired $parameters
     * @return \GlsApi\StructType\AdeZip_CustomsRequiredResponse|bool
     */
    public function adeZip_CustomsRequired(\GlsApi\StructType\AdeZip_CustomsRequired $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeZip_CustomsRequired($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeOption_Get
     * Meta information extracted from the WSDL
     * - documentation: Get system option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeOption_Get $parameters
     * @return \GlsApi\StructType\AdeOption_GetResponse|bool
     */
    public function adeOption_Get(\GlsApi\StructType\AdeOption_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeOption_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeOption_Set
     * Meta information extracted from the WSDL
     * - documentation: Set system option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeOption_Set $parameters
     * @return \GlsApi\StructType\AdeOption_SetResponse|bool
     */
    public function adeOption_Set(\GlsApi\StructType\AdeOption_Set $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeOption_Set($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by zip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeParcelShop_SearchByZip $parameters
     * @return \GlsApi\StructType\AdeParcelShop_SearchByZipResponse|bool
     */
    public function adeParcelShop_SearchByZip(\GlsApi\StructType\AdeParcelShop_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_SearchByID
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by ID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeParcelShop_SearchByID $parameters
     * @return \GlsApi\StructType\AdeParcelShop_SearchByIDResponse|bool
     */
    public function adeParcelShop_SearchByID(\GlsApi\StructType\AdeParcelShop_SearchByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_SearchByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeParcelShop_GetByCountry $parameters
     * @return \GlsApi\StructType\AdeParcelShop_GetByCountryResponse|bool
     */
    public function adeParcelShop_GetByCountry(\GlsApi\StructType\AdeParcelShop_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop2_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country (version 2)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeParcelShop2_GetByCountry $parameters
     * @return \GlsApi\StructType\AdeParcelShop2_GetByCountryResponse|bool
     */
    public function adeParcelShop2_GetByCountry(\GlsApi\StructType\AdeParcelShop2_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop2_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop2_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by Zip (version 2)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeParcelShop2_SearchByZip $parameters
     * @return \GlsApi\StructType\AdeParcelShop2_SearchByZipResponse|bool
     */
    public function adeParcelShop2_SearchByZip(\GlsApi\StructType\AdeParcelShop2_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop2_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * adePreparingBox_GetConsignCustomsDec
     * Meta information extracted from the WSDL
     * - documentation: Get consignment customs declarations from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePreparingBox_GetConsignCustomsDec $parameters
     * @return \GlsApi\StructType\AdePreparingBox_GetConsignCustomsDecResponse|bool
     */
    public function adePreparingBox_GetConsignCustomsDec(\GlsApi\StructType\AdePreparingBox_GetConsignCustomsDec $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignCustomsDec($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignCustomsDec
     * Meta information extracted from the WSDL
     * - documentation: Get customs declarations for consignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetConsignCustomsDec $parameters
     * @return \GlsApi\StructType\AdePickup_GetConsignCustomsDecResponse|bool
     */
    public function adePickup_GetConsignCustomsDec(\GlsApi\StructType\AdePickup_GetConsignCustomsDec $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignCustomsDec($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignPODs
     * Meta information extracted from the WSDL
     * - documentation: Get PODs pdf files from consignment (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePickup_GetConsignPODs $parameters
     * @return \GlsApi\StructType\AdePickup_GetConsignPODsResponse|bool
     */
    public function adePickup_GetConsignPODs(\GlsApi\StructType\AdePickup_GetConsignPODs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignPODs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePOD_Get
     * Meta information extracted from the WSDL
     * - documentation: Get POD pdf file for parcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdePOD_Get $parameters
     * @return \GlsApi\StructType\AdePOD_GetResponse|bool
     */
    public function adePOD_Get(\GlsApi\StructType\AdePOD_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePOD_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeCourier_Order
     * Meta information extracted from the WSDL
     * - documentation: Order courier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GlsApi\StructType\AdeCourier_Order $parameters
     * @return \GlsApi\StructType\AdeCourier_OrderResponse|bool
     */
    public function adeCourier_Order(\GlsApi\StructType\AdeCourier_Order $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeCourier_Order($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GlsApi\StructType\AdeCourier_OrderResponse|\GlsApi\StructType\AdeLang_ChangeResponse|\GlsApi\StructType\AdeLang_GetActiveResponse|\GlsApi\StructType\AdeLoginIntegratorResponse|\GlsApi\StructType\AdeLoginResponse|\GlsApi\StructType\AdeLogoutResponse|\GlsApi\StructType\AdeOption_GetResponse|\GlsApi\StructType\AdeOption_SetResponse|\GlsApi\StructType\AdeParcelShop2_GetByCountryResponse|\GlsApi\StructType\AdeParcelShop2_SearchByZipResponse|\GlsApi\StructType\AdeParcelShop_GetByCountryResponse|\GlsApi\StructType\AdeParcelShop_SearchByIDResponse|\GlsApi\StructType\AdeParcelShop_SearchByZipResponse|\GlsApi\StructType\AdePartner_GetParcelNumberResponse|\GlsApi\StructType\AdePfc_GetDictionaryResponse|\GlsApi\StructType\AdePfc_GetStatusResponse|\GlsApi\StructType\AdePickup_CreateResponse|\GlsApi\StructType\AdePickup_GetConsignBindsResponse|\GlsApi\StructType\AdePickup_GetConsignCustomsDecResponse|\GlsApi\StructType\AdePickup_GetConsignIDsResponse|\GlsApi\StructType\AdePickup_GetConsignLabelsExtResponse|\GlsApi\StructType\AdePickup_GetConsignLabelsResponse|\GlsApi\StructType\AdePickup_GetConsignPODsResponse|\GlsApi\StructType\AdePickup_GetConsignResponse|\GlsApi\StructType\AdePickup_GetIdentResponse|\GlsApi\StructType\AdePickup_GetIDsResponse|\GlsApi\StructType\AdePickup_GetLabelsResponse|\GlsApi\StructType\AdePickup_GetParcelLabelResponse|\GlsApi\StructType\AdePickup_GetParcelsLabelsResponse|\GlsApi\StructType\AdePickup_GetReceiptResponse|\GlsApi\StructType\AdePickup_GetResponse|\GlsApi\StructType\AdePickup_ParcelNumberSearchResponse|\GlsApi\StructType\AdePOD_GetResponse|\GlsApi\StructType\AdePreparingBox_DeleteConsignResponse|\GlsApi\StructType\AdePreparingBox_GetConsignCustomsDecResponse|\GlsApi\StructType\AdePreparingBox_GetConsignDocsResponse|\GlsApi\StructType\AdePreparingBox_GetConsignIDsResponse|\GlsApi\StructType\AdePreparingBox_GetConsignLabelsExtResponse|\GlsApi\StructType\AdePreparingBox_GetConsignLabelsResponse|\GlsApi\StructType\AdePreparingBox_GetConsignResponse|\GlsApi\StructType\AdePreparingBox_GetConsignsLabelsResponse|\GlsApi\StructType\AdePreparingBox_GetParcelLabelResponse|\GlsApi\StructType\AdePreparingBox_InsertExtResponse|\GlsApi\StructType\AdePreparingBox_InsertResponse|\GlsApi\StructType\AdeProfile_ChangeResponse|\GlsApi\StructType\AdeProfile_GetActiveResponse|\GlsApi\StructType\AdeProfile_GetIDsResponse|\GlsApi\StructType\AdeSendAddr_GetDictionaryResponse|\GlsApi\StructType\AdeSendAddr_GetStatusResponse|\GlsApi\StructType\AdeServices_GetAllowedResponse|\GlsApi\StructType\AdeServices_GetCountriesSDSResponse|\GlsApi\StructType\AdeServices_GetCountriesSRSResponse|\GlsApi\StructType\AdeServices_GetGuaranteedResponse|\GlsApi\StructType\AdeServices_GetMaxCODResponse|\GlsApi\StructType\AdeServices_GetMaxParcelWeightsResponse|\GlsApi\StructType\AdeZip_CustomsRequiredResponse|\GlsApi\StructType\AdeZip_GetCityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
