<?php

namespace snowaAnsar\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Smart ServiceType
 * @subpackage Services
 */
class Smart extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SmartSalesInventoryAndPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \snowaAnsar\StructType\SmartSalesInventoryAndPrice $parameters
     * @return \snowaAnsar\StructType\SmartSalesInventoryAndPriceResponse|bool
     */
    public function SmartSalesInventoryAndPrice(\snowaAnsar\StructType\SmartSalesInventoryAndPrice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SmartSalesInventoryAndPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \snowaAnsar\StructType\SmartSalesInventoryAndPriceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
