<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://novin2.snowa.ir/SmartServices.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://novin2.snowa.ir/SmartServices.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \snowaAnsar\ClassMap::get(),
);
/**
 * Samples for Smart ServiceType
 */
$smart = new \snowaAnsar\ServiceType\Smart($options);
/**
 * Sample call for SmartSalesInventoryAndPrice operation/method
 */
if ($smart->SmartSalesInventoryAndPrice(new \snowaAnsar\StructType\SmartSalesInventoryAndPrice()) !== false) {
    print_r($smart->getResult());
} else {
    print_r($smart->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \snowaAnsar\ServiceType\Insert($options);
/**
 * Sample call for InsertPreOrderInformationInQueue operation/method
 */
if ($insert->InsertPreOrderInformationInQueue(new \snowaAnsar\StructType\InsertPreOrderInformationInQueue()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
