<?php

namespace snowaAnsar\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityBase StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityBase
 * @subpackage Structs
 */
class EntityBase extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - ref: ser:Id
     * @var string
     */
    public $Id;
    /**
     * The Ref
     * Meta informations extracted from the WSDL
     * - ref: ser:Ref
     * @var string
     */
    public $Ref;
    /**
     * Constructor method for EntityBase
     * @uses EntityBase::setId()
     * @uses EntityBase::setRef()
     * @param string $id
     * @param string $ref
     */
    public function __construct($id = null, $ref = null)
    {
        $this
            ->setId($id)
            ->setRef($ref);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \snowaAnsar\StructType\EntityBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Ref value
     * @return string|null
     */
    public function getRef()
    {
        return $this->Ref;
    }
    /**
     * Set Ref value
     * @param string $ref
     * @return \snowaAnsar\StructType\EntityBase
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ref)), __LINE__);
        }
        $this->Ref = $ref;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \snowaAnsar\StructType\EntityBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
