<?php

namespace snowaAnsar\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderBuffer ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOrderBuffer
 * @subpackage Arrays
 */
class ArrayOfOrderBuffer extends AbstractStructArrayBase
{
    /**
     * The OrderBuffer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \snowaAnsar\StructType\OrderBuffer[]
     */
    public $OrderBuffer;
    /**
     * Constructor method for ArrayOfOrderBuffer
     * @uses ArrayOfOrderBuffer::setOrderBuffer()
     * @param \snowaAnsar\StructType\OrderBuffer[] $orderBuffer
     */
    public function __construct(array $orderBuffer = array())
    {
        $this
            ->setOrderBuffer($orderBuffer);
    }
    /**
     * Get OrderBuffer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \snowaAnsar\StructType\OrderBuffer[]|null
     */
    public function getOrderBuffer()
    {
        return isset($this->OrderBuffer) ? $this->OrderBuffer : null;
    }
    /**
     * Set OrderBuffer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \snowaAnsar\StructType\OrderBuffer[] $orderBuffer
     * @return \snowaAnsar\ArrayType\ArrayOfOrderBuffer
     */
    public function setOrderBuffer(array $orderBuffer = array())
    {
        foreach ($orderBuffer as $arrayOfOrderBufferOrderBufferItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderBufferOrderBufferItem instanceof \snowaAnsar\StructType\OrderBuffer) {
                throw new \InvalidArgumentException(sprintf('The OrderBuffer property can only contain items of \snowaAnsar\StructType\OrderBuffer, "%s" given', is_object($arrayOfOrderBufferOrderBufferItem) ? get_class($arrayOfOrderBufferOrderBufferItem) : gettype($arrayOfOrderBufferOrderBufferItem)), __LINE__);
            }
        }
        if (is_null($orderBuffer) || (is_array($orderBuffer) && empty($orderBuffer))) {
            unset($this->OrderBuffer);
        } else {
            $this->OrderBuffer = $orderBuffer;
        }
        return $this;
    }
    /**
     * Add item to OrderBuffer value
     * @throws \InvalidArgumentException
     * @param \snowaAnsar\StructType\OrderBuffer $item
     * @return \snowaAnsar\ArrayType\ArrayOfOrderBuffer
     */
    public function addToOrderBuffer(\snowaAnsar\StructType\OrderBuffer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \snowaAnsar\StructType\OrderBuffer) {
            throw new \InvalidArgumentException(sprintf('The OrderBuffer property can only contain items of \snowaAnsar\StructType\OrderBuffer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderBuffer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \snowaAnsar\StructType\OrderBuffer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \snowaAnsar\StructType\OrderBuffer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \snowaAnsar\StructType\OrderBuffer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \snowaAnsar\StructType\OrderBuffer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \snowaAnsar\StructType\OrderBuffer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderBuffer
     */
    public function getAttributeName()
    {
        return 'OrderBuffer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \snowaAnsar\ArrayType\ArrayOfOrderBuffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
